% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probabilistic.R
\name{expectedRewards}
\alias{expectedRewards}
\title{Expected Rewards for a markovchain}
\usage{
expectedRewards(markovchain,n,rewards)
}
\arguments{
\item{markovchain}{the markovchain-class object}

\item{n}{no of steps of the process}

\item{rewards}{vector depicting rewards coressponding to states}
}
\value{
returns a vector of expected rewards for different initial states
}
\description{
Given a markovchain object and reward values for every state,
function calculates expected reward value after n steps.
}
\details{
the function uses a dynamic programming approach to solve a 
recursive equation described in reference.
}
\examples{
transMatr<-matrix(c(0.99,0.01,0.01,0.99),nrow=2,byrow=TRUE)
simpleMc<-new("markovchain", states=c("a","b"),
             transitionMatrix=transMatr)
expectedRewards(simpleMc,1,c(0,1))
}
\references{
Stochastic Processes: Theory for Applications, Robert G. Gallager,
Cambridge University Press
}
\author{
Vandit Jain
}
