% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bpt_logl.R
\name{bpt_logl}
\alias{bpt_logl}
\title{A function to calculate the log-likelihood of BPT model}
\usage{
bpt_logl(param, x)
}
\arguments{
\item{param}{parameters of BPT model}

\item{x}{input data for BPT model}
}
\value{
returns the value of negative log-likelihood of the BPT model
}
\description{
A function to calculate the log-likelihood of BPT model
}
\examples{
set.seed(42)
data <-  rgamma(30,3,0.01)

# set some parameters
par_hat <- c(292.945125794581, 0.718247184450307) # estimated parameters
param <-  c(log(par_hat[1]),log(par_hat[2]^2)) # input parameters for logl function

# calculate log-likelihood
result <- marp::bpt_logl(param, data)

# print result
cat("-logl = ", result, "\n")

}
