% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_variables.R
\name{add_variables}
\alias{add_variables}
\title{Add variables to the analysis}
\usage{
add_variables(
  data,
  type = c("yvars", "xvars", "covariates", "interaction"),
  variables
)
}
\arguments{
\item{data}{The blueprint data object.}

\item{type}{The variable type, i.e. where it is located on the equation (y
position, x, as a covariate, etc.)}

\item{variables}{Variables to use for the type specified}
}
\value{
Adds variables to the blueprint
}
\description{
While different analyses use different types of variables, in general they
can be classified as in the 'y' or 'x' position of a statistical equation.
They can further be classified as covariates and as an interaction term.
}
\examples{

library(magrittr)
ds <- design(iris, 'cor') \%>\%
 add_settings()
add_variables(ds, 'xvar', 'Sepal.Length')
add_variables(ds, 'yvar', 'Petal.Length')

ds <- design(iris, 't.test')
ds <- add_variables(ds, 'yvar', c('Sepal.Length', 'Sepal.Width'))
ds <- add_variables(ds, 'xvar', 'Petal.Length')

}
