% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/black_figures.R
\name{star}
\alias{star}
\alias{s_star}
\title{Coordinates of a star}
\usage{
star(size.x = 10, size.y = 15, shd = "black", lwd = 3, lty = 0)

s_star(size.x = 10, size.y = 15, shd = "black", lwd = 3, lty = 0)
}
\arguments{
\item{size.x}{numeric, define the semi-major axis of the ellipse within which the figure is inscribed. Default is 10}

\item{size.y}{numeric, define the semi-minor axis of the ellipse within which the figure is inscribed. Default is 15}

\item{shd}{character, define the shading of the figure. Default is black}

\item{lwd}{integer, define the line width of the figure. Default is 3}

\item{lty}{integer, define the line type of the figure, default is 0}
}
\value{
Return the coordinates for drawing star composed of four lucks

Return the coordinates for drawing a single star composed of four lucks
}
\description{
Define the coordinates for drawing a star (composed of 4 luck)
}
\section{Functions}{
\itemize{
\item \code{s_star()}: Coordinates of a single star

Define the coordinates for drawing a single star (composed of 4 luck), to be used in shape()

}}
\examples{
# get the coordinates of a star composed of four luck
star()

# change the color of the star
draw(star(shd = "grey", lty = 0))
# get the coordinates of a single star composed of four luck
s_star()

# change the color of the star
draw(s_star(shd = "grey", lty = 0))
}
