% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_balance.R
\name{check_balance}
\alias{check_balance}
\title{Check balance after matching.}
\usage{
check_balance(Z, match_object, cov_list, plot_propens, propens)
}
\arguments{
\item{Z}{A vector of treatment indicator.}

\item{match_object}{An object returned by match_2C or match_2C_mat or match_2C_list.}

\item{cov_list}{A vector of names of covariates as appeared in the original dataset.}

\item{plot_propens}{Post-matching distribution of the estimated propensity scores in
two groups is plotted if TRUE; FALSE by default.}

\item{propens}{NULL by default. If plot_propens = TRUE, then a vector of
estimated propensity scores satisfying length(propens) = length(Z)
needs to be supplied.}
}
\value{
This function returns a data frame of the overall balance after statistical
matching. We tabulate the mean of each covariate in the cov_list in the treated group
and control groups after matching, and calculate their standardized differences, which
is defined as the mean difference divided by the pooled standard error before matching.
}
\description{
This function checks the overall balance after statistical matching.
}
