% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mb_get_runners.R
\name{mb_get_runners}
\alias{mb_get_runners}
\title{Get List of Available Runners for a given Market}
\usage{
mb_get_runners(session_data, event_id, market_id, runner_id = NULL,
  runner_states = c("open", "suspended"), include_prices = TRUE,
  side = NULL, include_withdrawn = TRUE)
}
\arguments{
\item{session_data}{A session object returned from a successful mb_login attempt. It contains details about your user preferences and security details.}

\item{event_id}{The event_id integer for the associated market.}

\item{market_id}{The market_id integer for which a list of associated runners is required.}

\item{runner_id}{If you only require details for a single runner, specify this optional runner_id integer.}

\item{runner_states}{A vector of string containing the runner states to return. Defaults to 'open' or 'suspended' market types.}

\item{include_prices}{A boolean for returning runner prices in the response. Defaults to TRUE.}

\item{side}{A filter to view the selected 'back' or 'lay' prices. The default is to return both.}

\item{include_withdrawn}{A boolean for returning or not the withdrawn runners in the response. Defaults to TRUE.}
}
\value{
If successful, a dataframe with associated runner information. 
The data frame has the following fields:
 \describe{
  \item{name}{Runner name}
  \item{status}{If betting is still available on this runner, it will have status='open'}
  \item{event-id}{Event id}
  \item{id}{Runner id}
  \item{market-id}{Market id}
}
If include_prices=TRUE then available prices for each runner are returned nested within the data frame.
}
\description{
List the Runners Available on Matchbook.com for a given Market
}
\examples{
\dontrun{my_session <- mb_login("my_user_name","my_password"); 
mb_get_runners(session_data=my_session,event_id=123456,market_id=1234567)}

}
\seealso{
\code{\link{mb_get_sports},\link{mb_get_events},\link{mb_get_markets}}
}

