% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mb_get_sports.R
\name{mb_get_sports}
\alias{mb_get_sports}
\title{Get List of Available Sports}
\usage{
mb_get_sports(session_data, nsports = 1000)
}
\arguments{
\item{session_data}{A session object returned from a successful \code{\link{mb_login}} attempt. It contains security details and your account preferences.}

\item{nsports}{The number of sports for which details are required. Default is 1000.}
}
\value{
If successful, a data frame with the following fields:
 \describe{
  \item{name}{sport name}
  \item{type}{the type of the sport}
  \item{id}{sport id}
  }
}
\description{
List the Sports currently available on Matchbook.com.
}
\examples{
\dontrun{my_session <- mb_login("my_user_name","versafepassword"); 
mb_get_sports(session_data=my_session)}

}
\seealso{
\code{\link{mb_get_events}}
}

