/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.memory.copy;

import choco.kernel.memory.AbstractEnvironment;
import choco.kernel.memory.IStateBinaryTree;
import choco.kernel.memory.IStateBool;
import choco.kernel.memory.IStateDouble;
import choco.kernel.memory.IStateDoubleVector;
import choco.kernel.memory.IStateInt;
import choco.kernel.memory.IStateIntProcedure;
import choco.kernel.memory.IStateIntVector;
import choco.kernel.memory.IStateLong;
import choco.kernel.memory.IStateLongVector;
import choco.kernel.memory.IStateObject;
import choco.kernel.memory.IStateVector;
import choco.kernel.memory.copy.RcBool;
import choco.kernel.memory.copy.RcDouble;
import choco.kernel.memory.copy.RcDoubleVector;
import choco.kernel.memory.copy.RcInt;
import choco.kernel.memory.copy.RcIntProcedure;
import choco.kernel.memory.copy.RcIntVector;
import choco.kernel.memory.copy.RcLong;
import choco.kernel.memory.copy.RcLongVector;
import choco.kernel.memory.copy.RcObject;
import choco.kernel.memory.copy.RcSave;
import choco.kernel.memory.copy.RcVector;
import choco.kernel.memory.copy.RecomputableElement;
import java.util.Stack;

public class EnvironmentCopying
extends AbstractEnvironment {
    private boolean newEl = false;
    protected static final Stack<Integer> clonedWorldIdxStack;
    public static RecomputableElement[][] elements;
    public static int[] indices;
    private static RcSave save;
    public int nbCopy = 0;

    public EnvironmentCopying() {
        int i = 9;
        while (--i >= 0) {
            EnvironmentCopying.indices[i] = 0;
        }
        clonedWorldIdxStack.clear();
        save = new RcSave(this);
    }

    public int getNbCopy() {
        return this.nbCopy;
    }

    public void add(RecomputableElement rc) {
        this.ensureCapacity(rc.getType(), indices[rc.getType()] + 1);
        int n = rc.getType();
        int n2 = indices[n];
        indices[n] = n2 + 1;
        EnvironmentCopying.elements[rc.getType()][n2] = rc;
        this.newEl = true;
    }

    private void ensureCapacity(int type, int n) {
        if (n > elements[type].length) {
            int newSize = elements[type].length;
            while (n >= newSize) {
                newSize = 3 * newSize / 2;
            }
            RecomputableElement[] oldElements = elements[type];
            EnvironmentCopying.elements[type] = new RecomputableElement[newSize];
            System.arraycopy(oldElements, 0, elements[type], 0, oldElements.length);
        }
    }

    @Override
    public void worldPush() {
        if (this.newEl) {
            EnvironmentCopying.save.currentElement = new RecomputableElement[9][];
            int i = 9;
            while (--i >= 0) {
                EnvironmentCopying.save.currentElement[i] = new RecomputableElement[indices[i]];
                System.arraycopy(elements[i], 0, EnvironmentCopying.save.currentElement[i], 0, indices[i]);
            }
            this.newEl = false;
        }
        this.saveEnv();
        ++this.currentWorld;
    }

    private void saveEnv() {
        if (this.currentWorld == 0 || this.currentWorld != clonedWorldIdxStack.peek()) {
            ++this.nbCopy;
            if (clonedWorldIdxStack.empty()) {
                clonedWorldIdxStack.push(this.currentWorld);
            } else if (clonedWorldIdxStack.peek() < this.currentWorld) {
                clonedWorldIdxStack.push(this.currentWorld);
            }
            save.save(this.currentWorld);
        }
    }

    @Override
    public void worldPop() {
        save.restore(--this.currentWorld);
        clonedWorldIdxStack.pop();
    }

    @Override
    public void clear() {
        int i = 9;
        while (--i >= 0) {
            EnvironmentCopying.indices[i] = 0;
        }
        clonedWorldIdxStack.clear();
        save.clear();
    }

    @Override
    public void worldCommit() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IStateInt makeInt() {
        return new RcInt(this);
    }

    @Override
    public IStateInt makeInt(int initialValue) {
        return new RcInt(this, initialValue);
    }

    @Override
    public IStateInt makeIntProcedure(IStateIntProcedure procedure, int initialValue) {
        return new RcIntProcedure(this, procedure, initialValue);
    }

    @Override
    public IStateBool makeBool(boolean initialValue) {
        return new RcBool(this, initialValue);
    }

    @Override
    public IStateIntVector makeIntVector() {
        return new RcIntVector(this);
    }

    @Override
    public IStateIntVector makeIntVector(int size, int initialValue) {
        return new RcIntVector(this, size, initialValue);
    }

    @Override
    public IStateIntVector makeIntVector(int[] entries) {
        return new RcIntVector(this, entries);
    }

    @Override
    public IStateLongVector makeLongVector(int size, long initialValue) {
        return new RcLongVector(this, size, initialValue);
    }

    @Override
    public IStateLongVector makeLongVector(long[] entries) {
        return new RcLongVector(this, entries);
    }

    @Override
    public IStateLongVector makeLongVector() {
        return new RcLongVector(this);
    }

    @Override
    public IStateDoubleVector makeDoubleVector() {
        return new RcDoubleVector(this);
    }

    @Override
    public IStateDoubleVector makeDoubleVector(int size, double initialValue) {
        return new RcDoubleVector(this, size, initialValue);
    }

    @Override
    public IStateDoubleVector makeDoubleVector(double[] entries) {
        return new RcDoubleVector(this, entries);
    }

    @Override
    public IStateDouble makeFloat() {
        return new RcDouble(this);
    }

    @Override
    public IStateDouble makeFloat(double initialValue) {
        return new RcDouble(this, initialValue);
    }

    @Override
    public IStateLong makeLong() {
        return new RcLong(this);
    }

    @Override
    public IStateLong makeLong(int init) {
        return new RcLong(this, init);
    }

    @Override
    public <T> IStateVector<T> makeVector() {
        return new RcVector(this);
    }

    @Override
    public IStateBinaryTree makeBinaryTree(int inf, int sup) {
        return null;
    }

    @Override
    public IStateObject makeObject(Object obj) {
        return new RcObject(this, obj);
    }

    static {
        elements = new RecomputableElement[9][64];
        indices = new int[9];
        clonedWorldIdxStack = new Stack();
    }
}

