/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.experimental.alg.color;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jgrapht.Graph;
import org.jgrapht.experimental.alg.ApproximationAlgorithm;
import org.jgrapht.experimental.alg.IntArrayGraphAlgorithm;

public class GreedyColoring<V, E>
extends IntArrayGraphAlgorithm<V, E>
implements ApproximationAlgorithm<Integer, V> {
    public static final int BEST_ORDER = 0;
    public static final int NATURAL_ORDER = 1;
    public static final int SMALLEST_DEGREE_LAST_ORDER = 2;
    public static final int LARGEST_SATURATION_FIRST_ORDER = 3;
    private int _order = 0;

    public GreedyColoring(Graph<V, E> graph) {
        this(graph, 0);
    }

    public GreedyColoring(Graph<V, E> graph, int n) {
        super(graph);
        this._order = n;
    }

    int color(int[] nArray) {
        int[] nArray2 = new int[this._neighbors.length];
        int n = 1;
        BitSet bitSet = new BitSet(this._neighbors.length);
        for (int i = 0; i < this._neighbors.length; ++i) {
            int n2 = nArray == null ? i : nArray[i];
            bitSet.clear();
            for (int j = 0; j < this._neighbors[n2].length; ++j) {
                int n3 = this._neighbors[n2][j];
                if (nArray2[n3] <= 0) continue;
                bitSet.set(nArray2[n3]);
            }
            nArray2[n2] = 1;
            while (bitSet.get(nArray2[n2])) {
                int n4 = n2;
                nArray2[n4] = nArray2[n4] + 1;
            }
            if (nArray2[n2] <= n) continue;
            n = nArray2[n2];
        }
        return n;
    }

    int[] smallestDegreeLastOrder() {
        int n;
        int[] nArray = new int[this._neighbors.length];
        int[] nArray2 = new int[this._neighbors.length];
        List[] listArray = new List[this._neighbors.length];
        int n2 = this._neighbors.length - 1;
        for (n = 0; n < this._neighbors.length; ++n) {
            listArray[n] = new ArrayList();
            nArray2[n] = this._neighbors[n].length;
        }
        for (n = 0; n < this._neighbors.length; ++n) {
            listArray[nArray2[n]].add(n);
        }
        for (n = 0; n < this._neighbors.length; ++n) {
            while (listArray[n].size() > 0) {
                int n3 = listArray[n].size() - 1;
                int n4 = (Integer)listArray[n].get(n3);
                listArray[n].remove(n3);
                nArray2[n4] = -1;
                nArray[n2--] = n4;
                for (int i = 0; i < this._neighbors[n4].length; ++i) {
                    int n5 = this._neighbors[n4][i];
                    if (nArray2[n5] < 0) continue;
                    listArray[nArray2[n5]].remove(new Integer(n5));
                    int n6 = n5;
                    nArray2[n6] = nArray2[n6] - 1;
                    listArray[nArray2[n5]].add(n5);
                    if (nArray2[n5] >= n) continue;
                    n = nArray2[n5];
                }
            }
        }
        return nArray;
    }

    int[] largestSaturationFirstOrder() {
        int n;
        int[] nArray = new int[this._neighbors.length];
        int[] nArray2 = new int[this._neighbors.length];
        int[] nArray3 = new int[this._neighbors.length];
        int[] nArray4 = new int[this._neighbors.length];
        int[] nArray5 = new int[this._neighbors.length];
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < this._neighbors.length; ++n) {
            nArray3[n] = n;
            nArray5[n] = n;
        }
        nArray4[0] = this._neighbors.length;
        while (n2 < this._neighbors.length) {
            while (n3 > 0 && nArray4[n3] == nArray4[n3 - 1]) {
                nArray4[n3--] = 0;
            }
            n = nArray3[nArray4[n3] - 1];
            int n4 = n3;
            nArray4[n4] = nArray4[n4] - 1;
            nArray2[n] = -1;
            nArray[n2++] = n;
            for (int i = 0; i < this._neighbors[n].length; ++i) {
                int n5 = this._neighbors[n][i];
                int n6 = nArray5[n5];
                if (nArray2[n5] < 0) continue;
                if (n6 != nArray4[nArray2[n5]] - 1) {
                    nArray3[n6] = nArray3[nArray4[nArray2[n5]] - 1];
                    nArray3[nArray4[nArray2[n5]] - 1] = n5;
                    nArray5[n5] = nArray4[nArray2[n5]] - 1;
                    nArray5[nArray3[n6]] = n6;
                }
                int n7 = nArray2[n5];
                nArray4[n7] = nArray4[n7] - 1;
                int n8 = n5;
                nArray2[n8] = nArray2[n8] + 1;
                if (nArray4[nArray2[n5]] == 0) {
                    nArray4[nArray2[n5]] = nArray4[nArray2[n5] - 1] + 1;
                }
                if (nArray2[n5] <= n3) continue;
                n3 = nArray2[n5];
            }
        }
        Collections.reverse(Arrays.asList(new int[][]{nArray3}));
        return nArray3;
    }

    @Override
    public Integer getLowerBound(Map<V, Object> map) {
        return 0;
    }

    @Override
    public Integer getUpperBound(Map<V, Object> map) {
        switch (this._order) {
            case 0: {
                return Math.min(Math.min(this.color(null), this.color(this.smallestDegreeLastOrder())), this.color(this.largestSaturationFirstOrder()));
            }
            case 1: {
                return this.color(null);
            }
            case 2: {
                return this.color(this.smallestDegreeLastOrder());
            }
            case 3: {
                return this.color(this.largestSaturationFirstOrder());
            }
        }
        return this._neighbors.length;
    }

    @Override
    public boolean isExact() {
        return false;
    }
}

