% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convFunctionCalls.R
\name{makeFuncMaps}
\alias{makeFuncMaps}
\title{Turn dictionary lines into functions that map matlab to R function calls}
\usage{
makeFuncMaps(addDict = NULL, pathDict = "")
}
\arguments{
\item{addDict}{An optional character vector with manufactored lines}

\item{pathDict}{The path to a text file with the dictionary lines written to it}
}
\value{
a list of functions to convert the arguments of a matlab function. It
  comes with the names of matlab functions.
}
\description{
Turn dictionary lines into functions that map matlab to R function calls
}
\details{
The output of the individual maps consits of the actual map for the
  given matlab arguments as a vector and a list of flags included in the
  dictionary. The argMap itself is a list of potential functions that could
  be used if a some flags are detected in the dictionary line. A more
  expansive look at the different dictionaries that could be used can be seen
  in the base dictionary at "extdata/HiebelerDict.txt" or in the vignette
  "vignettes/functionCalls.rmd". It returns a list with the R version of the
  arguments with a left parentheisis.
}
\examples{

funcMap <- makeFuncMaps("trace: sum, diag(\%1)")
funcMap[['trace']]$argMap[[1]]("matThing")
#$rargs
# "sum(diag(matThing)"

funcMap <- makeFuncMaps("mod: , 1 \%\% 2")
funcMap[['mod']]$argMap[[1]](c(4, 2))
#$rargs
# "(4, \%\%, 2"

test1 <- "mat"
test2 <- c("mat", "2")

funcMap <- makeFuncMaps(c("size--if 1:dim, 1", "size--if 2: ,dim(\%1)[\%2]"))
rightConv <- funcMap$size$flags$multSwitch(test1)
funcMap$size$argMap[[rightConv]](test1)
#$rargs
 "dim(mat"
 
rightConv <- funcMap$size$flags$multSwitch(test2)
funcMap$size$argMap[[rightConv]](test2)
#$rargs
 "dim(mat)[2]"
}

