\name{agram}
\alias{agram}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Scattergram visualization of associations between all pairs of variables. 
}
\description{
Uses the association array generated by \code{tap} to construct
an array of association diagrams (pie charts and scatterplots).
}
\usage{
agram(dataSet, method, ranking, order, ...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{dataSet}{
  the n x m data frame representing n samples of the m variables.
  }
  \item{method}{
  the method to use for linear association (included in the visualization)
  as performed by \code{cor}, 
  one of \code{"pearson"}, \code{"spearman"}, \code{"kendall"}. The default
  is \code{"pearson"}.
  }
  \item{ranking}{
  a logical specifying whether or not to rank the data points before
  producing the scatter plots. The default is \code{FALSE}.
  }
  \item{order}{
  determines the variable ordering.
  one of \code{FALSE} (the default for no re-grouping) or 
  \code{"PC"} (for principal components re-grouping)
  or \code{"OLO"} (for optimal leaf ordering)
  }
  \item{...}{
  passed on to graphics routines ...
  }
}
\details{
  Displays associations between all pairs of variables 
  as a graphics array using pie-charts above the diagonal 
  depicting the proportion of the total association 
  that can be explained by a linear trend in blue, 
  and the remaining non-linear association in red.
  
  Below the diagonal, scatter plots are shown and colored according to
  proportional non-linearity (see \code{nl3} returned by \code{\link{ma.nl}} ).
}
\value{
  Returns nothing.
}
\references{
This code was adapted from the \code{corrgram} package:

Author: Kevin Wright, 
Copyright: 2006 Kevin Wright, 
License: GPL2.

}
\author{
Ben Murrell, Dan Murrell & Hugh Murrell.
}
\note{
The data set can be of any dimension.
}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
\code{\link{ma}}
\code{\link{ma.nl}}
\code{\link{tap}}
}

\examples{
    data(baseballData)
    agram(baseballData,order="OLO",main="All pair associations for baseballData")
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ baseballData }
\keyword{ association }
