% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sum.R
\name{sum_MATLAB}
\alias{sum_MATLAB}
\alias{sum_MATLAB,array,missing-method}
\alias{sum_MATLAB,array,character-method}
\alias{sum_MATLAB,array,numeric-method}
\title{Sum of array elements}
\usage{
sum_MATLAB(A, dim)

\S4method{sum_MATLAB}{array,missing}(A)

\S4method{sum_MATLAB}{array,character}(A, dim)

\S4method{sum_MATLAB}{array,numeric}(A, dim)
}
\arguments{
\item{A}{vector, matrix or array}

\item{dim}{dimention over which A is to be summed}
}
\value{
The total, row or column sum of A
}
\description{
Returns the sum of the elements of the first input
}
\section{Methods (by class)}{
\itemize{
\item \code{sum_MATLAB(A = array, dim = missing)}: Sum elements of A along the first array dimension
whose size does not equal 1

\item \code{sum_MATLAB(A = array, dim = character)}: Computes the sum of all elements of A

\item \code{sum_MATLAB(A = array, dim = numeric)}: Computes the sum of all elements of A

}}
\examples{
x1 <- array(1:9, c(3, 3))
sum_MATLAB(x1)
sum_MATLAB(x1, "all")
sum_MATLAB(x1, 2)
}
\author{
Waldir Leoncio
}
