% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_annotate.R
\name{sim_annotate}
\alias{sim_annotate}
\title{Annotate a melted similarity matrix.}
\usage{
sim_annotate(
  sim_df,
  row_metadata,
  annotation_cols,
  index = "both",
  sim_cols = c("id1", "id2", "sim")
)
}
\arguments{
\item{sim_df}{data.frame with melted similarity matrix.}

\item{row_metadata}{data.frame with row metadata.}

\item{annotation_cols}{character vector specifying annotation columns.}

\item{index}{optional character string specifying whether to annotate left index, right index, or both.
This must be one of the strings \code{"both"} (default), \code{"left"}, \code{"right"}.}

\item{sim_cols}{optional character string specifying minimal set of columns for a similarity matrix}
}
\value{
Annotated melted similarity matrix of the same class as \code{sim_df}.
}
\description{
\code{sim_annotate} annotates a melted similarity matrix.
}
\examples{
suppressMessages(suppressWarnings(library(magrittr)))
population <- tibble::tibble(
  Metadata_group = sample(c("a", "b"), 4, replace = TRUE),
  Metadata_type = sample(c("x", "y"), 4, replace = TRUE),
  x = rnorm(4),
  y = x + rnorm(4) / 100,
  z = y + rnorm(4) / 1000
)
annotation_cols <- c("Metadata_group")
sim_df <- matric::sim_calculate(population, method = "pearson")
row_metadata <- attr(sim_df, "row_metadata")
matric::sim_annotate(sim_df, row_metadata, annotation_cols)
}
