% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/waerden.R
\name{waerden}
\alias{waerden}
\alias{row_waerden}
\alias{col_waerden}
\title{Van der Waerden Test}
\usage{
row_waerden(x, g)

col_waerden(x, g)
}
\arguments{
\item{x}{numeric matrix.}

\item{g}{a vector specifying group membership for each observation of x.}
}
\value{
a data.frame where each row contains the results of van det Waerden
test performed on the corresponding row/column of x.\cr\cr
Each row contains the following information (in order):\cr
1. obs.tot - total number of observations\cr
2. obs.groups - number of groups\cr
3. df - degrees of freedome\cr
4. statistic - van det Waerden chi-squared statistic\cr
5. pvalue - p.value
}
\description{
Performs van der Waerden test on each row/column of the input matrix.
}
\details{
\code{row_waerden(x, g)} - van der Waerden test on rows.
\code{col_waerden(x, g)} - van det Waerden test on columns.
}
\examples{
col_waerden(iris[,1:4], iris$Species)
row_waerden(t(iris[,1:4]), iris$Species)

}
\seealso{
\code{\link[PMCMR]{vanWaerden.test}}, \code{row_oneway_equalvar}, \code{row_kruskalwallis}
}
\author{
Karolis Koncevičius
}
