% Generated by roxygen2 (4.0.2): do not edit by hand
\name{inner.Horst}
\alias{inner.Horst}
\title{PLS inner estimation with the Horst scheme}
\usage{
inner.Horst(S, W, inner.mod, ignoreInnerModel = FALSE, ...)
}
\arguments{
\item{S}{Covariance matrix of the data.}

\item{W}{Weight matrix, where the indicators are on colums and composites are on the rows.}

\item{inner.mod}{A square matrix specifying the relationships of the composites in the model.}

\item{ignoreInnerModel}{Should the inner model be ignored and all correlations be used.}

\item{...}{Other parameters are ignored}
}
\value{
A matrix of unscaled inner weights \code{E} with the same dimesions as \code{inner.mod}.
}
\description{
Calculates a set of inner weights based on the Horst scheme.
}
\details{
In the Hosrt scheme, inner weights are unit weights for
composites that are connected in the model specified in \code{inner.mod} and zero otherwise.

Falls back to to identity scheme for composites that are not connected to any other composites.
}
\references{
Tenenhaus, A., & Tenenhaus, M. (2011). Regularized Generalized Canonical
Correlation Analysis. Psychometrika, 76(2), 257–284. doi:10.1007/s11336-011-9206-8
}
\seealso{
Other inner estimators: \code{\link{inner.GSCA}};
  \code{\link{inner.centroid}}; \code{\link{inner.factor}};
  \code{\link{inner.identity}}; \code{\link{inner.path}}
}

