% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrixpls.optim.R
\name{optimCriterion}
\alias{optim.gsca}
\alias{optim.maximizeFullR2}
\alias{optim.maximizeIndicatorR2}
\alias{optim.maximizeInnerR2}
\alias{optimCriterion}
\title{Optimization criteria functions}
\usage{
optim.maximizeInnerR2(matrixpls.res)

optim.maximizeIndicatorR2(matrixpls.res)

optim.maximizeFullR2(matrixpls.res)

optim.gsca(matrixpls.res)
}
\arguments{
\item{matrixpls.res}{An object of class \code{matrixpls} from which the
criterion function is calculated}
}
\value{
Value of the optimization criterion.
}
\description{
Optimization criterion functions calculate various optimization criterion values
from \code{matrixpls} objects.
}
\section{Functions}{
\itemize{
\item \code{optim.maximizeInnerR2}: maximizes the sum of R2 statistics of the \code{inner} matrix

\item \code{optim.maximizeIndicatorR2}: maximizes the sum of R2 statistics of the \code{reflective} matrix.

\item \code{optim.maximizeFullR2}: maximizes the sum of R2 statistics of the \code{inner} and \code{reflective} matrices.

\item \code{optim.gsca}: minimies the generalized structured component analysis criterion. See \link{GSCA}
}}
\seealso{
\code{\link{weight.optim}}
}

