% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/properties.R
\name{properties}
\alias{properties}
\alias{dim.matrixset}
\alias{dimnames.matrixset}
\alias{dimnames<-.matrixset}
\alias{matrixnames}
\alias{matrixnames<-}
\alias{matrix_elm}
\alias{matrix_elm<-}
\alias{nmatrix}
\alias{row_traits}
\alias{column_traits}
\alias{row_traits<-}
\alias{column_traits<-}
\alias{row_tag}
\alias{column_tag}
\alias{row_info}
\alias{row_info<-}
\alias{column_info}
\alias{column_info<-}
\alias{is_matrixset}
\title{Matrixset properties}
\usage{
\method{dim}{matrixset}(x)

\method{dimnames}{matrixset}(x)

\method{dimnames}{matrixset}(x) <- value

matrixnames(x)

matrixnames(x) <- value

matrix_elm(x, matrix)

matrix_elm(x, matrix) <- value

nmatrix(x)

row_traits(x)

column_traits(x)

row_traits(x) <- value

column_traits(x)

column_traits(x) <- value

row_tag(x)

column_tag(x)

row_info(x)

row_info(x) <- value

column_info(x)

column_info(x) <- value

is_matrixset(x)
}
\arguments{
\item{x}{\code{matrixset} object from which to retrieve information, or object
to test for being a \code{matrixset}.}

\item{value}{valid value for replacement}

\item{matrix}{index specifying matrix or matrices to extract. Index is
numeric or character vectors or empty (\code{NULL}). Note that
treating \code{NULL} as empty differs from the usual extraction,
where it is treated as \code{integer(0)}. Here a \code{NULL} (empty)
results in selecting all matrices.}
}
\value{
\code{ìs_matrixset} returns a \code{logical}.

\code{dim} returns a length-2 vector; \code{nrow} and \code{ncol} return length-1 vector.

\code{dimnames} returns a length-2 list; one component for each dimnames (row and
column). \code{rownames} and \code{colnames} each returns a \code{character} vector of
names.

\code{matrixnames} a\code{character} vector of matrix names, or \code{NULL}.

\code{nmatrix} returns an \code{ìnteger}.

\code{row_traits} and \code{column_traits} returns a \code{character} vector.

\code{row_tag} and \code{column_tag} returns a \code{character} vector.

\code{row_info} extracts the row annotation data frame. \code{column_info} does
the same thing for column annotation.
}
\description{
Utility functions to extract relevant information from a \code{matrixset} object.
}
\details{
\code{ìs_matrixset} tests if its argument is a proper \code{matrixset} object.

\code{dim} retrieves the dimension of the \code{matrixset} matrices (which are the
same for reach). Similarly,\code{nrow}  returns the number of rows for each
matrices, and \code{ncol} returns the number of columns.

\code{dimnames} retrieves the dimnames of the \code{matrixset} matrices (which are the
same for reach). Similarly, \code{rownames} (\code{colnames}) will retrieve row
(column) names.

\code{matrixnames} retrieves the matrix names, or \code{NULL} if the matrices are not
named.

\code{nmatrix} returns the number of matrices of a \code{matrixset}.

\code{row_traits} returns the object's row traits; these are the column names of
the row annotation data frame.

\code{column_traits} returns the object's column traits; these are the column
names of the column annotation data frame.

\code{row_info} extracts the row annotation data frame. \code{column_info} does
the same thing for column annotation.

\code{row_tag} returns the column name of \code{row_info} that stores the \code{matrixset}'s
row names. \code{column_tag} returns the column name of \code{column_info} that stores
the \code{matrixset}'s column names.

The replacement methods for \code{row_traits}/\code{row_info} and \code{column_traits}/\code{column_info}
can potentially change meta variables that were used for grouping. There is
always an attempt to keep the original groups, but they will be updated if it
is possible - a message is issued when that happens - and otherwise removed
altogether, with a warning.

\code{matrix_elm} extracts a single matrix. It's a wrapper to \code{x[,,matrix]}, but
returns the matrix element. The replacement method \code{matrix_elm} is also a
wrapper to \verb{x[,,matrix] <-}.
}
\examples{
is_matrixset(student_results)
dim(student_results)
c(nrow(student_results), ncol(student_results))
dimnames(student_results)
list(rownames(student_results), colnames(student_results))
matrixnames(student_results)
nmatrix(student_results)
list(row_traits(student_results), column_traits(student_results))
row_info(student_results)
column_info(student_results)

}
