% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Apply.R
\name{naryapplylogical_byname}
\alias{naryapplylogical_byname}
\title{Apply a function logically to numbers, matrices, or lists of numbers or matrices}
\usage{
naryapplylogical_byname(
  FUN,
  ...,
  .FUNdots = NULL,
  match_type = c("all", "matmult", "none"),
  set_rowcoltypes = TRUE,
  .organize = TRUE
)
}
\arguments{
\item{FUN}{a binary function (that returns logical values) to be applied over operands}

\item{...}{operands; constants, matrices, or lists of matrices}

\item{.FUNdots}{a list of additional named arguments passed to \code{FUN}.}

\item{match_type}{one of "\code{all}", "\code{matmult}", or "\code{none}".
When \code{...} are matrices,
"\code{all}" (the default) indicates that
rowtypes of all \code{...} matrices must match and
coltypes of all \code{...} matrices must match.
If "\code{matmult}",
the coltype of the first operand must match the rowtype of the second operand
for every sequential invocation of \code{FUN}.
If "\code{none}",
neither coltypes nor rowtypes are checked by \code{\link{naryapply_byname}}.}

\item{set_rowcoltypes}{tells whether to apply row and column types from 
operands in \code{...} to the output of each sequential invocation of \code{FUN}. 
Set \code{TRUE} (the default) to apply row and column types.
Set \code{FALSE}, to \emph{not} apply row and column types to the output.}

\item{.organize}{a boolean that tells whether or not to automatically 
complete operands in \code{...} relative to each other and
sort the rows and columns of the completed matrices.
This organizing is done on each sequential invocation of \code{FUN}.
Normally, this should be \code{TRUE} (the default).
However, if \code{FUN} takes over this responsibility, set to \code{FALSE}.}
}
\value{
the result of \code{FUN} applied logically to \code{...}
}
\description{
Operands should be logical, although numerical operands are accepted.
Numerical operands are interpreted as \code{0} is \code{FALSE}, and
any other number is \code{TRUE}.
}
\details{
This function is not exported, 
thereby retaining the right to future changes.
}
\examples{
matsbyname:::naryapplylogical_byname(`&`, TRUE, TRUE, TRUE)
matsbyname:::naryapplylogical_byname(`&`, TRUE, TRUE, FALSE)
}
