% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utilities.R
\name{logmean}
\alias{logmean}
\title{Logarithmic mean of two numbers}
\usage{
logmean(a, b, base = exp(1))
}
\arguments{
\item{a}{the first operand (must be non-negative)}

\item{b}{the second operand (must be non-negative)}

\item{base}{the base of the logarithm used in this calculation.
(Default is \code{exp(1)}.)}
}
\value{
\code{0} if \code{a = 0} or \code{b = 0}; \code{x1} if \code{a == b}; and
\code{(a - b) / log(a/b, base = base)}
for all other values of \code{a} and \code{b}
}
\description{
Calculates the logarithmic mean of two numbers.
}
\details{
This is an internal helper function for \code{logarithmicmean_byname}.
}
\examples{
matsbyname:::logmean(0, 0) # 0
matsbyname:::logmean(0, 1) # 0
matsbyname:::logmean(1, 0) # 0
matsbyname:::logmean(1, 1) # 1
matsbyname:::logmean(2, 1)
matsbyname:::logmean(1, 2) # commutative
matsbyname:::logmean(1, 10) # base = exp(1), the default
matsbyname:::logmean(1, 10, base = 10)
}
