% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Unary.R
\name{prodall_byname}
\alias{prodall_byname}
\title{Product of all elements in a matrix}
\usage{
prodall_byname(a)
}
\arguments{
\item{a}{The matrix whose elements are to be multiplied.}
}
\value{
The product of all elements in \code{a} as a numeric.
}
\description{
This function is equivalent to \verb{a \\\%>\\\% rowprods_byname() \\\%>\\\% colprods_byname()},
but returns a single numeric value instead of a 1x1 matrix.
}
\examples{
library(dplyr)
M <- matrix(2, nrow=2, ncol=2, dimnames = list(paste0("i", 1:2), paste0("c", 1:2))) \%>\%
  setrowtype("Industry") \%>\% setcoltype("Product")
prodall_byname(M)
rowprods_byname(M) \%>\% colprods_byname
# Also works for lists
prodall_byname(list(M,M))
DF <- data.frame(M = I(list()))
DF[[1,"M"]] <- M
DF[[2,"M"]] <- M
prodall_byname(DF$M[[1]])
prodall_byname(DF$M)
res <- DF \%>\% mutate(
  prods = prodall_byname(M)
)
res$prods
}
