% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reallocate.R
\name{reallocate_byname}
\alias{reallocate_byname}
\title{Reallocate values from one row or column to another}
\usage{
reallocate_byname(
  a,
  rowcolnames = NULL,
  margin = c(1, 2),
  .zero_behaviour = c("error", "warning", "zeroes", "allocate equally"),
  piece = "all",
  pattern_type = "exact",
  prepositions = RCLabels::prepositions_list,
  notation = RCLabels::notations_list,
  inf_notation = TRUE,
  choose_most_specific = FALSE
)
}
\arguments{
\item{a}{A matrix or a list of matrices.}

\item{rowcolnames}{The names of the rows or columns to be redistributed.}

\item{margin}{The margin of the matrix on which the \code{rowcolnames} are located.
Default is \code{c(1, 2)}, meaning that both rows (\code{1}) and columns (\code{2})
will be checked for \code{rowcolnames} and redistributed.}

\item{.zero_behaviour}{Tells how to proceed when remaining (i.e., unallocated)
rows or columns are all zero.
Default is "error", which throws an error.
See details for other options.}

\item{piece}{The piece of row or column names to be assessed.
Default is "all", indicating that the entire label will be assessed.}

\item{pattern_type}{The pattern type desired. Default is "exact".
Other options are "leading", "trailing", "anywhere",
and "literal".
See \code{\link[RCLabels:make_or_pattern]{RCLabels::make_or_pattern()}} for details.}

\item{prepositions}{Prepositions used by \code{\link[=select_rowcol_piece_byname]{select_rowcol_piece_byname()}}
for row and column name matching.
Default is \link[RCLabels:prepositions_list]{RCLabels::prepositions_list}.}

\item{notation}{The row or column notation used by \code{\link[=select_rowcol_piece_byname]{select_rowcol_piece_byname()}}
for row and column name matching.
Default is \link[RCLabels:notations_list]{RCLabels::notations_list}.}

\item{inf_notation}{A boolean used by \code{\link[=select_rowcol_piece_byname]{select_rowcol_piece_byname()}}
that tells whether to infer notation for rows and columns.
Default is \code{TRUE}.
See \code{\link[RCLabels:infer_notation]{RCLabels::infer_notation()}} for details.}

\item{choose_most_specific}{A boolean used by \code{\link[=select_rowcol_piece_byname]{select_rowcol_piece_byname()}}
that tells whether to choose the most specific
notation from \code{notation} when inferring notation.
Default is \code{FALSE} so that a less specific notation can be
inferred.
In combination with \link[RCLabels:notations_list]{RCLabels::notations_list},
the default value of \code{FALSE} means that
\link[RCLabels:bracket_notation]{RCLabels::bracket_notation} will be selected instead of
anything more specific, such as
\link[RCLabels:from_notation]{RCLabels::from_notation}.}
}
\value{
A modified version of \code{a} with \code{rowcolnames} redistributed.
}
\description{
There are situations where it is helpful to
reallocate values from one row or column to another,
in proportion to remaining values in corresponding columns or rows.
This function performs the reallocation operation.
See examples.
}
\details{
This function will provide answers, but
it is unlikely that the answers will be meaningful, when the
remaining data (the rows or columns not being allocated)
contain negative numbers.

When the remaining rows or columns not being reallocated
contain zeroes, the result is determined by \code{.zero_behaviour}.
Options are one of:
\itemize{
\item "error" (the default) to throw an error.
\item "warning" to issue a warning but continue execution. Be careful with this option!
\item "zeroes" to return zeroes in the row or column with zeroes. Note that "zeroes" and "warning" return the same value. "zeroes" does so without a warning.
\item "allocate equally" to equally allocate across remaining rows or columns.
}
}
\examples{
m <- matrix(c(1, 2, 3,
              4, 5, 6,
              7, 8, 9), 
            nrow = 3, ncol = 3, byrow = TRUE, 
            dimnames = list(c("r1", "r2", "r3"), 
            c("c1", "c2", "c3")))
m
# Move row 3 into the other rows (r1 and r2) proportionally
reallocate_byname(m, rowcolnames = "r3", margin = 1)
# Move column 2 into the other columns (c1 and c3) proportionally
reallocate_byname(m, rowcolnames = "c2", margin = 2)
# Demonstrate different options for reallocating when zeroes remain.
m2 <- matrix(c(1, 2,  0,
               4, 5,  0,
               7, 8, 10), 
             nrow = 3, ncol = 3, byrow = TRUE, 
             dimnames = list(c("r1", "r2", "r3"), 
             c("c1", "c2", "c3")))
m2
reallocate_byname(m2, rowcolnames = "r3", margin = 1, 
                  .zero_behaviour = "zeroes")
reallocate_byname(m2, rowcolnames = "r3", margin = 1, 
                  .zero_behaviour = "allocate equally")
}
