% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mazeHTML.R
\name{mazeHTML}
\alias{mazeHTML}
\title{Generate Elithorn Maze}
\usage{
mazeHTML(rank = 3, satPercent = 0.5, seed = 1, grid = NULL, wd = NULL,
  background = "#7abcff", boxBackground = "#66CDAA", fontColour = "white",
  Timer = TRUE, concerto = "C5")
}
\arguments{
\item{rank}{This is the Rank of the maze.}

\item{satPercent}{The saturation of the number of black dots created for a given grid. Range between 0-1.}

\item{seed}{To make sure that the randomness of the created black dots is captured and not repeated.}

\item{grid}{is the grid of the maze}

\item{wd}{is the working directory to save the HTML source code in. If not given, the file will be saved in the default working directory.}

\item{background}{The background colour of the page.}

\item{boxBackground}{The background colour of the box.}

\item{fontColour}{The font colour of the instructions.}

\item{Timer}{If True, a time limit of 4 mintues is given per question.}

\item{concerto}{The code varies between concerto version "C4" and "C5".}
}
\description{
This function generates an Elithorn Maze
}
\details{
This function creates a maze and is saved into your working directory.
A grid object needs to be called out first before runing the maze function.
The grid object needs to be the same as the rank given.
}
\examples{

rank <- 3
satPercent <- 0.5

#Grid must be same as rank
grid <- gridThreeUp

#Folder to save html/
#setwd("~/desktop")
#filePath<- getwd()

#Generate item
mazeHTML(rank,satPercent,seed=5,grid = grid,wd=NULL,
background="#7abcff",boxBackground="#66CDAA", fontColour="white ",
Timer=TRUE, concerto="C5")

}
\seealso{
\code{\link{mazeAbility}}, \code{\link{mazeDiff}}, \code{\link{np}}
}
\author{
Aiden Loe
}
