% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MBBE.R
\name{run_mbbe}
\alias{run_mbbe}
\title{Execute MBBE Analysis}
\usage{
run_mbbe(
  crash_value,
  ngroups,
  reference_groups,
  test_groups,
  num_parallel,
  samp_size,
  run_dir,
  model_source,
  nmfe_path,
  delta_parms,
  use_check_identifiable,
  NCA_end_time,
  rndseed,
  simulation_data_path,
  plan = c("multisession", "sequential", "multicore"),
  alpha_error = 0.05,
  NTID = FALSE,
  model_averaging_by = "study",
  user_R_code = FALSE,
  R_code_path = "",
  save_plots = FALSE,
  ...
)
}
\arguments{
\item{crash_value}{Numeric. Value to be returned for BIC in models that crash during either bootstrap or simulation.}

\item{ngroups}{Integer. Number of groups in the simulated data (e.g., an ABBA design has 4 groups).}

\item{reference_groups}{Numeric vector. Indices of the groups representing the reference formulation (e.g., c(2,3) for an ABBA design).}

\item{test_groups}{Numeric vector. Indices of the groups representing the test formulation (e.g., c(1,4) for an ABBA design).}

\item{num_parallel}{Integer. Number of NONMEM processes (both bootstrap and simulation) to run concurrently.}

\item{samp_size}{Integer. Size of the bootstrap and simulation samples.}

\item{run_dir}{Character string. Directory for NONMEM execution.}

\item{model_source}{Character string. Paths to the NONMEM control files for model averaging.}

\item{nmfe_path}{Character string. Path to the nmfe executable.}

\item{delta_parms}{Numeric. Parameter difference threshold defining identifiability.}

\item{use_check_identifiable}{Logical. Should identifiability be checked based on the criterion defined by \href{https://www.page-meeting.org/default.asp?abstract=5951}{Aoki}?}

\item{NCA_end_time}{Numeric. The NCA calculation will start at 0 and end at this value.}

\item{rndseed}{Integer. Random seed for reproducibility.}

\item{simulation_data_path}{Character string. Path to the simulation dataset.}

\item{plan}{Character string (default: "multisession"). Parallel execution plan. Can be "multisession", "sequential", or "multicore".}

\item{alpha_error}{Numeric (default: 0.05). Alpha error rate for statistical tests.}

\item{NTID}{Logical (default: FALSE). Is the drug a narrow therapeutic index drug?}

\item{model_averaging_by}{Character string (default: "study"). Method of model averaging, either "study" or "subject".}

\item{user_R_code}{Logical (default: FALSE). Should custom R code be used for model penalty?}

\item{R_code_path}{Character string. If \code{user_R_code} is TRUE, this parameter defines the path to the custom R script.}

\item{save_plots}{Logical (default: \code{FALSE}). Set to \code{TRUE} to save plot output.}

\item{...}{Additional args}
}
\value{
A list containing:
\itemize{
\item \code{Cmax_power}: Power for Cmax
\item \code{AUClast_power}: Power for AUClast
\item \code{AUCinf_power}: Power for AUCinf
\item \code{run_dir}: Directory where the function was executed
\item \code{Num_identifiable}: Number of identifiable parameters
\item \code{BICS}: Bayesian Information Criterion Scores
}
}
\description{
This function runs the MBBE analysis. It's typically called by \code{run_mbbe_json}
which provides the necessary options via a JSON file.
}
\details{
This function is primarily intended to be called by \code{run_mbbe_json}, which provides input parameters through a JSON configuration.
}
