% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aipe_smd.R
\name{aipe_smd}
\alias{aipe_smd}
\title{Accuracy in Parameter Estimation: Standardized Mean Difference}
\usage{
aipe_smd(moe, paired = c(TRUE, FALSE), conf.int, assur.lvl, r)
}
\arguments{
\item{moe}{target margin of error in standard deviation units}

\item{paired}{(character) logical indicator specifying if \code{x} and \code{y} are paired \code{(TRUE)} or independent \code{(FALSE)}}

\item{conf.int}{(optional) confidence level of the interval. Defaults to \code{0.90}}

\item{assur.lvl}{(optional) desired level of \emph{assurance} (percent experiments whose MOE is less than target MOE). Defaults to \code{0.99}}

\item{r}{(required if \code{paired = TRUE}) population correlation between the two measures}
}
\description{
Estimates sample size for paired or independent, two-sample study desings via Accuracy in Parameter Estimation. Calculates \emph{n} so a given study is likely to obtain margin of error no larger than chosen target margin of error.
}
\details{
Refer to vignette for further information.
}
\examples{
aipe_smd(moe = 0.55, paired = TRUE, conf.int = .9, assur.lvl = .99, r = 0.75)
}
\references{
Maxwell SE, Kelley K & Rausch JR. (2008). Sample size planning for statistical power and accuracy in parameter estimation. \emph{Annual Review of Psychology}, 59, 537-563.

Kelley K & Rausch JR. (2006). Sample size planning for the standardized mean difference: Accuracy in parameter estimation via narrow confidence intervals. \emph{Psychological Methods}, 11, 363–385.
}
