% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cor_stat.R
\name{.cor_stat}
\alias{.cor_stat}
\title{Calculate general stationary correlation.}
\usage{
.cor_stat(base, lagrangian, par_base, par_lagr, lambda, base_fixed = FALSE)
}
\arguments{
\item{base}{Base model, \code{sep} or \code{fs} for now. Or correlation matrix/array.}

\item{lagrangian}{Lagrangian model, \code{none}, \code{lagr_tri}, or \code{lagr_askey}.}

\item{par_base}{Parameters for the base model (symmetric), used only when
\code{base_fixed = FALSE}.}

\item{par_lagr}{Parameters for the Lagrangian model. Used only when
\code{lagrangian} is not \code{none}.}

\item{lambda}{Weight of the Lagrangian term, \eqn{\lambda\in[0, 1]}.}

\item{base_fixed}{Logical; if TRUE, \code{base} is the correlation.}
}
\value{
Correlations for the general stationary model. Same dimension of
\code{base} if \code{base_fixed = FALSE}.
}
\description{
Calculate general stationary correlation.
}
\details{
The general station model, a convex combination of a base model
and a Lagrangian model, has the form
\deqn{C(\mathbf{h}, u)=(1-\lambda)C_{\text{Base}}(\mathbf{h}, u)+
\lambda C_{\text{Lagr}}(\mathbf{h}, u),}
where \eqn{\lambda} is the weight of the Lagrangian term.

If \code{base_fixed = TRUE}, the correlation is of the form
\deqn{C(\mathbf{h}, u)=(1-\lambda)C_{\text{Base}}+
\lambda C_{\text{Lagr}}(\mathbf{h}, u),}
where \code{base} is a correlation matrix/array and \code{par_base} and \code{h} are not
used.

When \code{lagrangian = "none"}, \code{lambda} must be 0.
}
\references{
Gneiting, T., Genton, M., & Guttorp, P. (2006). Geostatistical Space-Time
Models, Stationarity, Separability, and Full Symmetry. In C&H/CRC
Monographs on Statistics & Applied Probability (pp. 151–175).
Chapman and Hall/CRC.
}
\keyword{internal}
