% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcgf_sim.R
\name{.mcgf_sim}
\alias{.mcgf_sim}
\title{Simulate Markov chain Gaussian field}
\usage{
.mcgf_sim(
  N,
  base,
  lagrangian,
  par_base,
  par_lagr,
  lambda,
  dists,
  sd,
  lag,
  scale_time = 1,
  horizon = 1,
  init = 0,
  mu_c,
  mu_p,
  return_all = FALSE
)
}
\arguments{
\item{N}{Sample size.}

\item{base}{Base model, \code{sep} or \code{fs} for now.}

\item{lagrangian}{Lagrangian model, "none" or \code{lagr_tri} for now.}

\item{par_base}{Parameters for the base model (symmetric).}

\item{par_lagr}{Parameters for the Lagrangian model.}

\item{lambda}{Weight of the Lagrangian term, \eqn{\lambda\in[0, 1]}.}

\item{dists}{Distance matrices or arrays.}

\item{sd}{Standard deviation for each location.}

\item{lag}{Time lag.}

\item{scale_time}{Scale of time unit, default is 1. \code{lag} is divided by
\code{scale_time}.}

\item{horizon}{Forecast horizon, default is 1.}

\item{init}{Initial samples, default is 0.}

\item{mu_c, mu_p}{Means of current and past.}

\item{return_all}{Logical; if TRUE the joint covariance matrix, arrays of
distances and time lag are returned.}
}
\value{
Simulated Markov chain Gaussian field with user-specified covariance
structure. The simulation is done by kriging. The output data is in
space-wide format. \code{dists} must contain \code{h} for symmetric models, and \code{h1}
and \code{h2} for general stationary models. \code{horizon} controls forecasting
horizon. \code{sd}, \code{mu_c}, \code{mu_p}, and \code{init} must be vectors of appropriate
sizes.
}
\description{
Simulate Markov chain Gaussian field
}
\keyword{internal}
