% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pdims.R
\name{pdims.mcmcarray}
\alias{pdims.mcmcarray}
\title{Parameter Dimensions}
\usage{
\method{pdims}{mcmcarray}(x, ...)
}
\arguments{
\item{x}{An object.}

\item{...}{Other arguments passed to methods.}
}
\value{
A named list of integer vectors of the dimensions of each parameter.
}
\description{
Gets the dimensions of each parameter of an object.
}
\examples{
\dontshow{if (requireNamespace("nlist", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(nlist)

pdims(nlist(x = 1:3))
pdims(nlist(y = 3, zz = matrix(2:5, 2)))
\dontshow{\}) # examplesIf}
}
\seealso{
Other dimensions: 
\code{\link[universals]{dims}()},
\code{\link[universals]{ndims}()},
\code{\link[universals]{npdims}()}
}
