% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_eval.R
\name{residuals-fitted-values}
\alias{residuals-fitted-values}
\alias{fitted.draws}
\alias{residuals.draws}
\title{Extract draws of fitted values or residuals from a draws object}
\usage{
\method{fitted}{draws}(
  object,
  mean.only = FALSE,
  units = NULL,
  chains = seq_len(nchains(object)),
  draws = seq_len(ndraws(object)),
  matrix = FALSE,
  type = c("link", "response"),
  ...
)

\method{residuals}{draws}(
  object,
  mean.only = FALSE,
  units = NULL,
  chains = seq_len(nchains(object)),
  draws = seq_len(ndraws(object)),
  matrix = FALSE,
  ...
)
}
\arguments{
\item{object}{a draws object.}

\item{mean.only}{if \code{TRUE} only the vector of posterior means is returned. In that case
the subsequent arguments are ignored. Default is \code{FALSE}.}

\item{units}{the data units (by default all) for which fitted values or residuals should be
computed.}

\item{chains}{optionally, a selection of chains.}

\item{draws}{optionally, a selection of draws per chain.}

\item{matrix}{whether a matrix should be returned instead of a dc object.}

\item{type}{the type of fitted values: "link" for fitted values on the linear predictor scale
(the default), and "response" for fitted values on the response scale. Returned residuals are
always on the response scale.}

\item{...}{currently not used.}
}
\value{
Either a draws component object or a matrix with draws of fitted values or residuals.
 The residuals are always on the response scale, whereas fitted values can
 be on the scale of the linear predictor or the response depending on \code{type}.
 If \code{mean.only=TRUE}, a vector of posterior means.
}
\description{
For a model created with \code{\link{create_sampler}} and estimated using \code{\link{MCMCsim}},
these functions return the posterior draws of fitted values or residuals.
In the current implementation the fitted values correspond to the linear predictor
and the residuals are computed as the data vector minus the fitted values,
regardless of the model's distribution family.
For large datasets the returned object can become very large. One may therefore
select a subset of draws or chains or use \code{mean.only=TRUE} to
return a vector of posterior means only.
}
\examples{
\donttest{
ex <- mcmcsae_example(n=50)
sampler <- create_sampler(ex$model, data=ex$dat)
sim <- MCMCsim(sampler, burnin=100, n.iter=300, thin=2, store.all=TRUE)
fitted(sim, mean.only=TRUE)
summary(fitted(sim))
residuals(sim, mean.only=TRUE)
summary(residuals(sim))
bayesplot::mcmc_intervals(as.matrix(subset(residuals(sim), vars=1:20)))
}

}
