% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prediction.R
\name{generate_data}
\alias{generate_data}
\title{Generate a data vector according to a model}
\usage{
generate_data(
  formula,
  data = NULL,
  family = "gaussian",
  ny = NULL,
  ry = NULL,
  r.mod,
  sigma.fixed = NULL,
  sigma.mod = NULL,
  Q0 = NULL,
  formula.V = NULL,
  linpred = NULL
)
}
\arguments{
\item{formula}{A model formula, see \code{\link{create_sampler}}.
Any left-hand-side of the formula is ignored.}

\item{data}{see \code{\link{create_sampler}}.}

\item{family}{sampling distribution family, see \code{\link{create_sampler}}.}

\item{ny}{see \code{\link{create_sampler}}.}

\item{ry}{see \code{\link{create_sampler}}.}

\item{r.mod}{see \code{\link{create_sampler}}.}

\item{sigma.fixed}{see \code{\link{create_sampler}}.}

\item{sigma.mod}{see \code{\link{create_sampler}}.}

\item{Q0}{see \code{\link{create_sampler}}.}

\item{formula.V}{see \code{\link{create_sampler}}.}

\item{linpred}{see \code{\link{create_sampler}}.}
}
\value{
A list with a generated data vector and a list of prior means of the
 parameters. The parameters are drawn from their priors.
}
\description{
This function generates draws from the prior predictive distribution.
Parameter values are drawn from their priors, and consequently data is
generated from the sampling distribution given these parameter values.
}
\examples{
\donttest{
n <- 250
dat <- data.frame(
  x = rnorm(n),
  g = factor(sample(1:10, n, replace=TRUE)),
  ny = 10
)
gd <- generate_data(
  ~ reg(~ 1 + x, prior=pr_normal(precision=10, mean=c(0, 1)), name="beta") +
    gen(factor = ~ g, name="v"),
  family="binomial", ny="ny", data=dat
)
gd
plot(dat$x, gd$y)
}

}
