% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MCMCsim.R
\name{print.dc_summary}
\alias{print.dc_summary}
\title{Display a summary of a \code{dc} object}
\usage{
\method{print}{dc_summary}(
  x,
  digits = 3L,
  max.lines = 1000L,
  tail = FALSE,
  sort = NULL,
  max.label.length = NULL,
  ...
)
}
\arguments{
\item{x}{an object of class \code{dc_summary}.}

\item{digits}{number of digits to use, defaults to 3.}

\item{max.lines}{maximum number of lines to display.
If \code{NULL}, all elements are displayed.}

\item{tail}{if \code{TRUE} the last instead of first at most \code{max.lines} are displayed.}

\item{sort}{column name on which to sort the output.}

\item{max.label.length}{if specified, printed row labels will be abbreviated to at most this length.}

\item{...}{passed on to \code{print.default}.}
}
\description{
Display a summary of a \code{dc} object
}
\examples{
\donttest{
ex <- mcmcsae_example()
sampler <- create_sampler(ex$model, data=ex$dat)
sim <- MCMCsim(sampler, store.all=TRUE)
print(summary(sim$u), sort="n_eff")
}

}
