% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/targets.R
\name{calc_relative_mse}
\alias{calc_relative_mse}
\title{Calculate Relative Mean Squared Error and its Monte Carlo Standard Error}
\usage{
calc_relative_mse(estimates, true_param)
}
\arguments{
\item{estimates}{A numeric vector of estimates from a simulation or sampling process.}

\item{true_param}{The true parameter value that the estimates are intended to approximate.
Note that `true_param` must not be zero, as the calculation involves division by the true parameter value.}
}
\value{
A list with two components: `rel_mse`, the calculated Relative Mean Squared Error of the estimates,
and `rel_mse_mcse`, the Monte Carlo Standard Error of the Relative MSE. If `true_param` is zero,
both `rel_mse` and `rel_mse_mcse` will be `NA`.
}
\description{
Computes the Relative Mean Squared Error (Relative MSE) of a set of estimates with respect to a true
parameter value, along with the Monte Carlo Standard Error (MCSE) of the Relative MSE. The Relative
MSE is a normalized measure of error that scales the Mean Squared Error (MSE) by the square of the
true parameter value, making it particularly useful for comparing the accuracy of estimates across
different scales. The function also calculates the MCSE for the Relative MSE, taking into account the
variance, skewness, and kurtosis of the estimates to provide a measure of uncertainty. The function
returns `NA` for both Relative MSE and its MCSE if the true parameter is zero, to avoid division by zero.
}
\examples{
estimates <- rnorm(100, mean = 50, sd = 10)
true_param <- 50 # Non-zero true parameter
relative_mse_info <- calc_relative_mse(estimates, true_param)
print(relative_mse_info)
}
