% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runsim.R
\name{runsim}
\alias{runsim}
\title{Run simulations in parallel}
\usage{
runsim(
  n,
  grid_params,
  sim_func,
  show_progress = TRUE,
  num_cores = parallel::detectCores() - 1
)
}
\arguments{
\item{n}{The number of times the simulation function should be executed for each
set of parameters. Must be a positive integer.}

\item{grid_params}{A dataframe where each row corresponds to a unique combination
of parameters for the simulation. Typically generated using the `expand.grid()` function.}

\item{sim_func}{The simulation function to be applied. This function should accept
parameters corresponding to a row in `grid_params` and return a dataframe or a list
that can be row-bound.}

\item{show_progress}{Logical indicating whether to display progress messages
during the execution of the simulations.}

\item{num_cores}{The number of cores to use for parallel execution. By default, the
number is set to one less than the total number of cores available on the system
to leave resources for other processes. On Windows, due to the lack of support for
multicore execution using forking, the default is set to 1 regardless of the number
of cores available.}
}
\value{
A dataframe combining the results of all simulations, with an additional
column to identify the set of parameters (from `grid_params`) used for each simulation.
}
\description{
Executes a series of simulations in parallel, based on a set of parameters
specified in a dataframe. This function is designed to facilitate large-scale
simulation studies by leveraging multiple cores to distribute the computational load.
}
\details{
This function first validates the input parameters, ensuring that `n` is
a positive integer, `grid_params` is a dataframe, and `sim_func` is a valid function.
It then uses parallel processing to apply `sim_func` to each combination of parameters
specified in `grid_params`, repeating each simulation `n` times. The results are
combined into a single dataframe, which is returned to the caller. The parallel
execution mode utilized is multicore, through the `parallel` package.
}
\note{
The multicore parallel mode is only supported on macOS and Linux-based operating
systems. Users on other operating systems, such as Windows, may not experience the
same parallel processing capabilities and should consider alternative methods for
parallel execution.
}
\examples{
# Define a simple simulation function
sim_function <- function(a, b) {
  Sys.sleep(0.02) # Simulating a time-consuming process
  return(data.frame(result = a + b))
}

# Generate a grid of parameters
params <- expand.grid(a = 1:3, b = 4:6)

# Run simulations
results <- runsim(n = 2, grid_params = params, sim_func = sim_function, num_cores = 2)
print(results)

}
\seealso{
\code{\link[parallel]{mcmapply}} for the underlying parallel apply mechanism.
}
