/*
 * Decompiled with CFR 0.152.
 */
package multidendrograms.dendrogram.figures;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.text.NumberFormat;
import java.util.Locale;
import multidendrograms.definitions.SettingsInfo;
import multidendrograms.dendrogram.Scaling;
import multidendrograms.dendrogram.eps.EpsUtils;
import multidendrograms.types.DendrogramOrientation;
import multidendrograms.types.PlotType;
import multidendrograms.types.ProximityType;

public class AxisLabel {
    private Color color;
    private ProximityType proximityType;
    private DendrogramOrientation dendroOrientation;
    private double minValue;
    private double maxValue;
    private double increment;
    private int ticksGroup;
    private int numLabels;
    private FontRenderContext renderContext;
    private NumberFormat numberFormat;
    private Scaling scaling;
    private double x0;
    private double yMin;
    private double yMax;
    private double rotationAngle;
    private Font font;
    private double labelsMaxWidth;

    public AxisLabel(SettingsInfo settingsInfo, Scaling scaling) {
        this.color = settingsInfo.getAxisLabelColor();
        this.proximityType = settingsInfo.getProximityType();
        this.dendroOrientation = settingsInfo.getDendrogramOrientation();
        this.minValue = settingsInfo.getAxisMinValue();
        this.maxValue = settingsInfo.getAxisMaxValue();
        this.increment = settingsInfo.getAxisIncrement();
        this.ticksGroup = settingsInfo.getAxisTicks();
        int n = settingsInfo.getAxisNumberOfTicks();
        this.numLabels = 1 + (n - 1) / this.ticksGroup;
        this.renderContext = new FontRenderContext(null, true, true);
        int n2 = settingsInfo.getAxisLabelDecimals();
        this.numberFormat = NumberFormat.getInstance(Locale.ENGLISH);
        this.numberFormat.setMinimumFractionDigits(n2);
        this.numberFormat.setMaximumFractionDigits(n2);
        this.numberFormat.setGroupingUsed(false);
        this.scaling = scaling;
        if (this.dendroOrientation.equals((Object)DendrogramOrientation.NORTH) || this.dendroOrientation.equals((Object)DendrogramOrientation.SOUTH)) {
            this.x0 = scaling.transformX(0.0);
            this.yMin = scaling.transformY(this.minValue);
            this.yMax = scaling.transformY(this.maxValue);
            this.rotationAngle = 0.0;
        } else {
            this.x0 = scaling.transformY(0.0);
            this.yMin = scaling.transformX(this.minValue);
            this.yMax = scaling.transformX(this.maxValue);
            this.rotationAngle = 90.0;
        }
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.rotate(Math.toRadians(-this.rotationAngle));
        Font font = settingsInfo.getAxisLabelFont();
        this.font = font.deriveFont(affineTransform);
        this.setLabelsMaximumWidth();
    }

    private void setLabelsMaximumWidth() {
        this.labelsMaxWidth = 0.0;
        double d = this.proximityType.equals((Object)ProximityType.DISTANCE) ? this.minValue : this.maxValue;
        for (int i = 0; i < this.numLabels; ++i) {
            String string = String.valueOf(this.numberFormat.format(d));
            TextLayout textLayout = new TextLayout(string, this.font, this.renderContext);
            Rectangle2D rectangle2D = textLayout.getBounds();
            this.labelsMaxWidth = this.dendroOrientation.equals((Object)DendrogramOrientation.NORTH) || this.dendroOrientation.equals((Object)DendrogramOrientation.SOUTH) ? Math.max(this.labelsMaxWidth, rectangle2D.getWidth()) : Math.max(this.labelsMaxWidth, rectangle2D.getHeight());
            if (this.proximityType.equals((Object)ProximityType.DISTANCE)) {
                d += (double)this.ticksGroup * this.increment;
                continue;
            }
            d -= (double)this.ticksGroup * this.increment;
        }
    }

    public void draw(PlotType plotType, Graphics2D graphics2D) {
        Color color = null;
        Font font = null;
        if (plotType.equals((Object)PlotType.PANEL)) {
            color = graphics2D.getColor();
            graphics2D.setColor(this.color);
            font = graphics2D.getFont();
        } else {
            EpsUtils.writeLine("gsave");
            EpsUtils.writeLine(EpsUtils.setRGBColor((float)this.color.getRed() / 255.0f, (float)this.color.getGreen() / 255.0f, (float)this.color.getBlue() / 255.0f));
            String string = this.font.getPSName();
            if (string.equals("Dialog.plain")) {
                EpsUtils.writeLine(EpsUtils.scaleSetFont("/ArialMT", this.font.getSize()));
            } else {
                EpsUtils.writeLine(EpsUtils.scaleSetFont("/" + string, this.font.getSize()));
            }
        }
        double d = this.proximityType.equals((Object)ProximityType.DISTANCE) ? this.minValue : this.maxValue;
        for (int i = 0; i < this.numLabels; ++i) {
            float f;
            float f2;
            String string = String.valueOf(this.numberFormat.format(d));
            TextLayout textLayout = new TextLayout(string, this.font, this.renderContext);
            Rectangle2D rectangle2D = textLayout.getBounds();
            if (this.dendroOrientation.equals((Object)DendrogramOrientation.NORTH)) {
                f2 = (float)(this.x0 + (this.labelsMaxWidth - rectangle2D.getWidth()));
                f = (float)(this.scaling.transformY(d) - rectangle2D.getHeight() / 2.0);
            } else if (this.dendroOrientation.equals((Object)DendrogramOrientation.SOUTH)) {
                f2 = (float)(this.x0 + (this.labelsMaxWidth - rectangle2D.getWidth()));
                f = (float)(this.yMin + (this.yMax - this.scaling.transformY(d)) - rectangle2D.getHeight() / 2.0);
            } else if (this.dendroOrientation.equals((Object)DendrogramOrientation.EAST)) {
                f2 = (float)(this.scaling.transformX(d) + rectangle2D.getWidth() / 2.0);
                f = (float)(this.x0 + (this.labelsMaxWidth - rectangle2D.getHeight()));
            } else {
                f2 = (float)(this.yMin + (this.yMax - this.scaling.transformX(d)) + rectangle2D.getWidth() / 2.0);
                f = (float)(this.x0 + (this.labelsMaxWidth - rectangle2D.getHeight()));
            }
            if (plotType.equals((Object)PlotType.PANEL)) {
                graphics2D.scale(1.0, -1.0);
                textLayout.draw(graphics2D, f2, -f);
                graphics2D.scale(1.0, -1.0);
            } else {
                EpsUtils.writeLine(EpsUtils.bottomLeftTextRotated((float)EpsUtils.xmin + f2, (float)EpsUtils.ymax + f, (float)this.rotationAngle, string));
            }
            if (this.proximityType.equals((Object)ProximityType.DISTANCE)) {
                d += (double)this.ticksGroup * this.increment;
                continue;
            }
            d -= (double)this.ticksGroup * this.increment;
        }
        if (plotType.equals((Object)PlotType.PANEL)) {
            graphics2D.setColor(color);
            graphics2D.setFont(font);
        } else {
            EpsUtils.writeLine("grestore");
        }
    }
}

