/*
 * Decompiled with CFR 0.152.
 */
package multidendrograms.direct;

import java.io.IOException;
import multidendrograms.core.clusterings.BetaFlexible;
import multidendrograms.core.clusterings.Centroid;
import multidendrograms.core.clusterings.CompleteLinkage;
import multidendrograms.core.clusterings.HierarchicalClustering;
import multidendrograms.core.clusterings.SingleLinkage;
import multidendrograms.core.clusterings.VersatileLinkage;
import multidendrograms.core.clusterings.Ward;
import multidendrograms.core.definitions.Dendrogram;
import multidendrograms.core.definitions.SymmetricMatrix;
import multidendrograms.data.DataFile;
import multidendrograms.data.ExternalData;
import multidendrograms.dendrogram.ConnectedGraph;
import multidendrograms.dendrogram.DendrogramMeasures;
import multidendrograms.dendrogram.ToJson;
import multidendrograms.dendrogram.ToNewick;
import multidendrograms.dendrogram.ToTxt;
import multidendrograms.dendrogram.UltrametricMatrix;
import multidendrograms.initial.Language;
import multidendrograms.initial.MethodName;
import multidendrograms.types.BandHeight;
import multidendrograms.types.MethodType;
import multidendrograms.types.OriginType;
import multidendrograms.types.ProximityType;

public class DirectClustering {
    public static final int AUTO_PRECISION = Integer.MIN_VALUE;
    public static final String MEASURES_SUFIX = "-measures.txt";
    public static final String ULTRAMETRIC_SUFIX = "-ultrametric.txt";
    public static final String GRAPH_SUFIX = "-graph.net";
    public static final String TXT_TREE_SUFIX = "-tree.txt";
    public static final String NEWICK_TREE_SUFIX = "-newick.txt";
    public static final String JSON_TREE_SUFIX = ".json";
    private DataFile dataFile;
    private ExternalData externalData;
    private ProximityType proximityType;
    private int precision;
    private String filePrefix;
    private OriginType originType;
    private BandHeight bandHeight;
    private HierarchicalClustering clustering;
    private UltrametricMatrix ultraMatrix = null;
    private DendrogramMeasures dendroMeasures = null;

    public DirectClustering(String string, ProximityType proximityType, int n, MethodType methodType, double d, boolean bl, OriginType originType, BandHeight bandHeight) throws Exception {
        this.dataFile = new DataFile(string);
        this.externalData = new ExternalData(this.dataFile);
        this.proximityType = proximityType;
        SymmetricMatrix symmetricMatrix = this.externalData.getProximityMatrix();
        this.precision = n;
        if (this.precision == Integer.MIN_VALUE) {
            this.precision = this.externalData.getPrecision();
        }
        this.filePrefix = DirectClustering.getFilePrefix(this.dataFile.getPathNameNoExt(), proximityType, this.precision, methodType, d, bl);
        this.originType = originType;
        this.bandHeight = bandHeight;
        if (symmetricMatrix.minimumValue() < 0.0 && (methodType.equals((Object)MethodType.VERSATILE_LINKAGE) || methodType.equals((Object)MethodType.GEOMETRIC_LINKAGE))) {
            throw new Exception(Language.getLabel(80));
        }
        System.out.println("Data file        : " + string);
        System.out.println("Proximity type   : " + proximityType.toString().toLowerCase());
        System.out.println("Precision        : " + this.precision);
        System.out.println("Method name      : " + methodType.toString().toLowerCase());
        System.out.println("Method parameter : " + d);
        System.out.println("Weighted         : " + bl);
        System.out.println("Origin           : " + this.originType.toString().toLowerCase());
        System.out.println("---");
        this.clustering = DirectClustering.newClustering(methodType, symmetricMatrix, this.externalData.getNames(), proximityType, this.precision, bl, d);
        this.clustering.build();
    }

    public static String getFilePrefix(String string, ProximityType proximityType, int n, MethodType methodType, double d, boolean bl) {
        String string2 = string;
        string2 = proximityType.equals((Object)ProximityType.DISTANCE) ? string2 + "-d" + n + "-" : string2 + "-s" + n + "-";
        if (bl && (methodType.equals((Object)MethodType.VERSATILE_LINKAGE) || methodType.equals((Object)MethodType.ARITHMETIC_LINKAGE) || methodType.equals((Object)MethodType.GEOMETRIC_LINKAGE) || methodType.equals((Object)MethodType.HARMONIC_LINKAGE) || methodType.equals((Object)MethodType.CENTROID) || methodType.equals((Object)MethodType.BETA_FLEXIBLE))) {
            string2 = string2 + "w";
        }
        string2 = string2 + MethodName.toShortName(methodType);
        if (methodType.equals((Object)MethodType.VERSATILE_LINKAGE) || methodType.equals((Object)MethodType.BETA_FLEXIBLE)) {
            string2 = string2 + d;
        }
        return string2;
    }

    public void printMeasures() {
        if (this.ultraMatrix == null) {
            this.ultraMatrix = new UltrametricMatrix(this.clustering.getRoot(), this.externalData.getNames(), this.originType, this.bandHeight);
        }
        if (this.dendroMeasures == null) {
            this.dendroMeasures = new DendrogramMeasures(this.externalData.getProximityMatrix(), this.clustering.getRoot(), this.ultraMatrix.getMatrix());
        }
        System.out.println("Normalized Tree Balance            : " + this.dendroMeasures.getTreeBalance());
        System.out.println("Cophenetic Correlation Coefficient : " + this.dendroMeasures.getCopheneticCorrelation());
        System.out.println("Normalized Mean Squared Error      : " + this.dendroMeasures.getSquaredError());
        System.out.println("Normalized Mean Absolute Error     : " + this.dendroMeasures.getAbsoluteError());
        System.out.println("Space Distortion                   : " + this.dendroMeasures.getSpaceDistortion());
        System.out.println("---");
    }

    public void saveMeasures() {
        if (this.ultraMatrix == null) {
            this.ultraMatrix = new UltrametricMatrix(this.clustering.getRoot(), this.externalData.getNames(), this.originType, this.bandHeight);
        }
        if (this.dendroMeasures == null) {
            this.dendroMeasures = new DendrogramMeasures(this.externalData.getProximityMatrix(), this.clustering.getRoot(), this.ultraMatrix.getMatrix());
        }
        String string = this.filePrefix + MEASURES_SUFIX;
        try {
            this.dendroMeasures.save(string);
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
        }
    }

    public void saveUltrametric() {
        if (this.ultraMatrix == null) {
            this.ultraMatrix = new UltrametricMatrix(this.clustering.getRoot(), this.externalData.getNames(), this.originType, this.bandHeight);
        }
        String string = this.filePrefix + ULTRAMETRIC_SUFIX;
        try {
            this.ultraMatrix.saveAsTxt(string);
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
        }
    }

    public void saveGraph() {
        if (this.ultraMatrix == null) {
            this.ultraMatrix = new UltrametricMatrix(this.clustering.getRoot(), this.externalData.getNames(), this.originType, this.bandHeight);
        }
        String string = this.filePrefix + GRAPH_SUFIX;
        ConnectedGraph connectedGraph = new ConnectedGraph(this.externalData.getProximityMatrix(), this.externalData.getNames(), this.proximityType, this.precision, this.ultraMatrix.getMatrix());
        try {
            connectedGraph.saveAsNet(string);
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
        }
    }

    public void saveAsTxt() {
        String string = this.filePrefix + TXT_TREE_SUFIX;
        ToTxt toTxt = new ToTxt(this.clustering.getRoot());
        try {
            toTxt.saveAsTxt(string);
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
        }
    }

    public void saveAsNewick() {
        String string = this.filePrefix + NEWICK_TREE_SUFIX;
        Dendrogram dendrogram = this.clustering.getRoot();
        boolean bl = this.originType.equals((Object)OriginType.UNIFORM_ORIGIN);
        ToNewick toNewick = new ToNewick(dendrogram, bl);
        try {
            toNewick.saveAsNewick(string);
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
        }
    }

    public void saveAsJson() {
        String string = this.filePrefix + JSON_TREE_SUFIX;
        Dendrogram dendrogram = this.clustering.getRoot();
        boolean bl = this.originType.equals((Object)OriginType.UNIFORM_ORIGIN);
        ToJson toJson = new ToJson(dendrogram, bl);
        try {
            toJson.saveAsJson(string);
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
        }
    }

    public static HierarchicalClustering newClustering(MethodType methodType, SymmetricMatrix symmetricMatrix, String[] stringArray, ProximityType proximityType, int n, boolean bl, double d) {
        HierarchicalClustering hierarchicalClustering;
        boolean bl2 = proximityType.equals((Object)ProximityType.DISTANCE);
        switch (methodType) {
            case VERSATILE_LINKAGE: {
                double d2 = DirectClustering.inverseSigmoid(d);
                hierarchicalClustering = new VersatileLinkage(symmetricMatrix, stringArray, bl2, n, bl, d2);
                break;
            }
            case SINGLE_LINKAGE: {
                hierarchicalClustering = new SingleLinkage(symmetricMatrix, stringArray, bl2, n);
                break;
            }
            case COMPLETE_LINKAGE: {
                hierarchicalClustering = new CompleteLinkage(symmetricMatrix, stringArray, bl2, n);
                break;
            }
            case ARITHMETIC_LINKAGE: {
                double d3 = 1.0;
                hierarchicalClustering = new VersatileLinkage(symmetricMatrix, stringArray, bl2, n, bl, d3);
                break;
            }
            case GEOMETRIC_LINKAGE: {
                double d4 = 0.0;
                hierarchicalClustering = new VersatileLinkage(symmetricMatrix, stringArray, bl2, n, bl, d4);
                break;
            }
            case HARMONIC_LINKAGE: {
                double d5 = -1.0;
                hierarchicalClustering = new VersatileLinkage(symmetricMatrix, stringArray, bl2, n, bl, d5);
                break;
            }
            case CENTROID: {
                hierarchicalClustering = new Centroid(symmetricMatrix, stringArray, bl2, n, bl);
                break;
            }
            case WARD: {
                hierarchicalClustering = new Ward(symmetricMatrix, stringArray, bl2, n);
                break;
            }
            case BETA_FLEXIBLE: {
                hierarchicalClustering = new BetaFlexible(symmetricMatrix, stringArray, bl2, n, bl, d);
                break;
            }
            default: {
                hierarchicalClustering = null;
            }
        }
        return hierarchicalClustering;
    }

    private static double inverseSigmoid(double d) {
        if (d <= -1.0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (d >= 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        double d2 = 0.1;
        return Math.log((1.0 + d) / (1.0 - d)) / Math.log((1.0 + d2) / (1.0 - d2));
    }
}

