% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/L2Lnormalized.R
\name{L2L.normalized}
\alias{L2L.normalized}
\title{Compute normalized version of a graph Laplcian matrix}
\usage{
L2L.normalized(L)
}
\arguments{
\item{L}{graph Laplcian matrix}
}
\value{
normalized graph Laplacian matrix
}
\description{
Compute normalized version of a graph Laplcian matrix
}
\examples{
# Construct exemplary Adjacency and corresponding Laplacian matrices
p1 <- 10
p2 <- 90
p <- p1 + p2
A <- matrix(rep(0, p * p), p, p)
A[1:p1, 1:p1] <- 1
A[(p1 + 1):p, (p1 + 1):p] <- 1
diag(A) <- 0
diagL <- apply(A, 1, sum)
L <- -A
diag(L) <- diagL
vizu.mat(L, "L Laplacian matrix")

# Compute normalized version of a Laplacian matrix
L.norm <- L2L.normalized(L)
vizu.mat(L.norm, "L Laplacian matrix (normalized)")

}

