% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scidb.R
\name{src_scidb}
\alias{src_scidb}
\alias{dbConnect_scidb}
\alias{mysql_scidb}
\title{src_scidb}
\usage{
src_scidb(dbname, ...)

dbConnect_scidb(dbname, ...)

mysql_scidb(dbname, ...)
}
\arguments{
\item{dbname}{the name of the database to which you want to connect}

\item{...}{arguments passed to \code{\link[dbplyr]{src_dbi}} or \code{\link[DBI]{dbConnect}}}
}
\value{
For \code{\link{src_scidb}}, a \code{\link[dbplyr]{src_dbi}} object

For \code{\link{dbConnect_scidb}}, a \code{\link[RMariaDB]{MariaDBConnection-class}} object

For \code{\link{mysql_scidb}}, a character vector of length 1 to be used
as an \code{engine.ops} argument, or on the command line.
}
\description{
Connect to the scidb server on Amazon Web Services.
}
\details{
This is a public, read-only account. Any abuse will be considered a 
hostile act.
}
\examples{
\dontrun{
db_air <- src_scidb("airlines")
db_air
}
\dontrun{
db_air <- dbConnect_scidb("airlines")
db_air
if (require(DBI)) {
  dbListTables(db_air)
}
}

if (require(knitr)) {
  opts_chunk$set(engine.opts = mysql_scidb("airlines"))
}
}
\seealso{
\code{\link[dbplyr]{src_dbi}}

\code{\link[RMariaDB]{MariaDBConnection-class}}

\code{\link[knitr]{opts_chunk}}
}
