% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poisson_maxsprt.R
\name{poisson_maxsprt}
\alias{poisson_maxsprt}
\alias{poisson_maxsprt.mds_ts}
\alias{poisson_maxsprt.default}
\title{Poisson MaxSPRT}
\usage{
poisson_maxsprt(df, ...)

\method{poisson_maxsprt}{mds_ts}(df, ts_event = c(Count = "nA"),
  analysis_of = NA, ...)

\method{poisson_maxsprt}{default}(df, analysis_of = NA,
  eval_period = NULL, obs_period = 3, alpha = 0.05, M = 4,
  u_t = NA, ...)
}
\arguments{
\item{df}{Required input data frame of class \code{mds_ts} or, for generic
usage, any data frame with the following columns:
\describe{
  \item{time}{Unique times of class \code{Date}}
  \item{event}{Either the event count or rate of class \code{numeric}}
}}

\item{...}{Further arguments passed onto \code{poisson_maxsprt} methods,
which are currently select parameters for
\code{Sequential::SampleSize.Poisson()} as follows: \code{RR}, \code{power},
and \code{D}.}

\item{ts_event}{Required if \code{df} is of class \code{mds_ts}. Named string
indicating the variable corresponding to the event count (cell A in the 2x2
contingency table). In most cases, the default is the appropriate setting.
See details for alternative options.

Default: \code{c("Count"="nA")} corresponding to the event count column in
\code{mds_ts} objects. Name is generated from \code{mds_ts} metadata.}

\item{analysis_of}{Optional string indicating the English description of what
was analyzed. If specified, this will override the name of the
\code{ts_event} string parameter.

Default: \code{NA} indicates no English description for plain \code{df}
data frames, or \code{ts_event} English description for \code{df} data frames
of class \code{mds_ts}.

Example: \code{"Count of bone cement leakages"}}

\item{eval_period}{Positive integer indicating the number of unique
times counting in reverse chronological order to evaluate. If \code{u_t} is
not specified, \code{eval_period} less \code{obs_period} will be used
to establish an empirical null Poisson distribution, \code{u_t}.

Default: \code{NULL} considers all times in \code{df}.}

\item{obs_period}{Positive integer indicating the number of unique
times in reverse chronological order to observe and test against the null
hypothesis, described by \code{u_t}. This cannot be greater than
\code{eval_period}.

Default: \code{3} indicates the last 3 times from \code{df} constitute the
observation period. It is not \code{1} to emphasize its use on rarely
occurring events. The user is encouraged to explicitly set \code{obs_period}.}

\item{alpha}{Required Type I error probability in the range (0, 0.5].

Default: \code{0.05} is a significance level of 5\%.}

\item{M}{Required minimum number of events needed during the observation
period \code{obs_period} before the null hypothesis can be
rejected. Passed into \code{Sequential::SampleSize.Poisson()}.

Default: \code{4} is a minimum of 4 events, per Kulldorff and Silva, 2015.}

\item{u_t}{Optional value for the mean of the null Poisson distribution used
to test the hypothesis.

Default: \code{NA} will infer the null distribution from the data using the
\code{eval_period} less the \code{obs_period}.}
}
\value{
A named list of class \code{mdsstat_test} object, as follows:
\describe{
  \item{test_name}{Name of the test run}
  \item{analysis_of}{English description of what was analyzed}
  \item{status}{Named boolean of whether the test was run. The name contains
  the run status.}
  \item{result}{A standardized list of test run results: \code{statistic}
  for the test statistic, \code{lcl} and \code{ucl} for the set
  confidence bounds, \code{p} for the p-value, \code{signal} status,
  \code{signal_threshold}, and other MaxSPRT test values.}
  \item{params}{The test parameters}
  \item{data}{The data on which the test was run}
}
}
\description{
Test on device-events using the Poisson Maximized Sequential Probability
Ratio Test, or Poisson MaxSPRT, originally proposed by Kulldorff et al
(2011). Requires a call to Silva & Kulldorff's \code{Sequential} package.
}
\details{
Runs a variant of Kulldorff's Poisson MaxSPRT where the mean of the null
Poisson distribution, \code{u_t}, reflecting the baseline risk of the event,
can be inferred from the data as the evaluation period, \code{eval_period},
less the observation period, \code{obs_period}.

This null distribution is used in conjunction with \code{alpha}, \code{M},
and other parameters passed into \code{Sequential::SampleSize.Poisson()} to
establish the critical MaxSPRT log likelihood ratios. Additional parameters
eligible to be passed via \code{...} are \code{power}, \code{D}, and
\code{RR}.

The following constraints are on this test: 1) If \code{u_t} is being
inferred from the data, the total number of events used to construct
\code{u_t} must be at least
equal to the required sample size in order to control Type I error, per
Li 2009.
2) The total number of observed events cannot be greater than the length
of surveillance (required sample size).

For parameter \code{ts_event}, in the uncommon case where the
device-event count (Cell A) variable is not \code{"nA"}, the name of the
variable may be specified here. A named character
vector may be used where the name is the English description of what was
analyzed. Note that if the parameter \code{analysis_of} is specified, it will
override this name. Example: \code{ts_event=c("Count of Bone Cement
Leakages"="event_count")}
}
\section{Methods (by class)}{
\itemize{
\item \code{mds_ts}: Poisson MaxSPRT on mds_ts data

\item \code{default}: Poisson MaxSPRT on general data
}}

\examples{
# Basic Example
data <- data.frame(time=c(1:25), event=as.integer(stats::rnorm(25, 100, 25)))
a1 <- poisson_maxsprt(data)
# Example using an mds_ts object
a2 <- poisson_maxsprt(mds_ts[[3]])

}
\references{
Martin Kulldorff, Robert L. Davis, Margarette Kolczak, Edwin Lewis, Tracy Lieu & Richard Platt (2011) A Maximized Sequential Probability Ratio Test for Drug and Vaccine Safety Surveillance, Sequential Analysis, 30:1, 58-78.

Ivair Ramos Silva, Martin Kulldorff (2019). Sequential: Exact Sequential Analysis for Poisson and Binomial Data. R package version 3.0.1. https://CRAN.R-project.org/package=Sequential

Lingling Li, Martin Kulldorff (2009). A conditional maximized sequential probability ratio test for Pharmacovigilance. Statistics in Medicine. doi:10.1002/sim.3780
}
