% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conv_dim.R
\encoding{UTF-8}
\name{conv_dim}
\alias{conv_dim}
\title{Convert Dimensions of Measurement}
\usage{
conv_dim(x, x_unit, trans, trans_unit, y, y_unit)
}
\arguments{
\item{x}{a numeric vector giving the measurement value in the first dimension.}

\item{x_unit}{the unit in which \code{x} was measured.}

\item{trans}{a numeric vector giving the measurement value in the transition dimension.}

\item{trans_unit}{the unit in which \code{trans} was measured.}

\item{y}{a numeric vector giving the measurement value in the second dimension.}

\item{y_unit}{the unit in which \code{y} was measured.}
}
\description{
Converts between dimensions of measurement given a transition dimension (the dimension that "bridges" \code{x} and \code{y}, e.g. liters per second, lbs per acre). Note that 2 of the 3 measurements (\code{x}, \code{y}, or \code{trans}) must be defined to calculate the 3rd. See \code{\link{conv_unit_options}} for all options.
}
\details{
This function supports all dimensions in \code{conv_unit_options} except for coordinates. The conversion values have been defined based primarily from international weight and measurement authorities (e.g. General Conference on Weights and Measures, International Committee for Weights and Measures, etc.). While much effort was made to make conversions as accurate as possible, you should check the accuracy of conversions to ensure that conversions are precise enough for your applications.
}
\note{
\describe{
 \item{Duration}{Years are defined as 365.25 days and months are defined as 1/12 a year.}
 \item{Energy}{cal is a thermochemical calorie (4.184 J) and Cal is 1000 cal (kcal or 4184 J).}
 \item{Flow}{All gallon-based units are US gallons.}
 \item{Mass}{All non-metric units are based on the avoirdupois system.}
 \item{Power}{hp is mechanical horsepower, or 745.69 W.}
 \item{Speed}{mach is calculated at sea level at 15 °C.}
}
}
\examples{
# How many minutes does it take to travel 100 meters at 3 feet per second?
conv_dim(x = 100, x_unit = "m", trans = 3, trans_unit = "ft_per_sec", y_unit = "min")

# How many degrees does the temperature increase with an increase in 4 kPa given 0.8 Celcius
# increase per psi?
conv_dim(x_unit = "C", trans = 0.8, trans_unit = "C_per_psi", y = 4, y_unit = "kPa")

# Find the densities given volume and mass measurements.
conv_dim(x = c(60, 80), x_unit = "ft3", trans_unit = "kg_per_l", y = c(6e6, 4e6), y_unit = "g")

}
\seealso{
\code{\link{conv_unit_options}}, \code{\link{conv_unit}}
}
\author{
Matthew A. Birk, \email{matthewabirk@gmail.com}
}
