% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/el_control.R
\name{el_control}
\alias{el_control}
\title{Control parameters for computation}
\usage{
el_control(
  maxit = 200L,
  maxit_l = 25L,
  tol = 1e-06,
  tol_l = 1e-06,
  step = NULL,
  th = NULL,
  nthreads
)
}
\arguments{
\item{maxit}{Maximum number of iterations for constrained minimization of
empirical likelihood. Defaults to \code{200}.}

\item{maxit_l}{Maximum number of iterations of evaluation of empirical
likelihood. Defaults to \code{25}.}

\item{tol}{Convergence tolerance for the constrained minimization.
Defaults to \code{1e-06}.}

\item{tol_l}{Relative convergence tolerance for the evaluation. Defaults
to \code{1e-06}.}

\item{step}{Step size for projected gradient method. Defaults to \code{NULL}
and set to the reciprocal of sample size.}

\item{th}{Threshold for negative empirical log-likelihood ratio value.
The iteration stops if the value exceeds the threshold. Defaults to
\code{NULL}.}

\item{nthreads}{Number of threads for parallel computation via OpenMP (if
available).}
}
\value{
An object of class of \linkS4class{ControlEL}.
}
\description{
Specifies details of computation of (constrained) empirical likelihood.
}
\examples{
optcfg <- el_control(maxit = 300L, th = 200, nthreads = 1L)
}
\seealso{
\link{el_eval}, \link{lht}
}
