% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/full.series.graph.R
\name{full.series.graph}
\alias{full.series.graph}
\title{Creates the historical series graph of the datasets}
\usage{
full.series.graph(i.data, i.range.x = NA, i.range.y = NA, i.output = ".",
  i.graph.title = "", i.graph.subtitle = "", i.graph.file = T,
  i.graph.file.name = "", i.plot.timing = F, i.plot.intensity = F,
  i.alternative.thresholds = NA, i.color.pattern = c("#C0C0C0", "#606060",
  "#000000", "#808080", "#000000", "#001933", "#00C000", "#800080", "#FFB401",
  "#8c6bb1", "#88419d", "#810f7c", "#4d004b"), ...)
}
\arguments{
\item{i.data}{Historical data series.}

\item{i.range.x}{Range x (surveillance weeks) of graph.}

\item{i.range.y}{Range y of graph.}

\item{i.output}{Directory where graph is saved.}

\item{i.graph.title}{Title of the graph.}

\item{i.graph.subtitle}{Subtitle of the graph.}

\item{i.graph.file}{Graph to a file.}

\item{i.graph.file.name}{Name of the graph.}

\item{i.plot.timing}{Plot the timing of epidemics.}

\item{i.plot.intensity}{Plot the intensity levels.}

\item{i.alternative.thresholds}{Use alternative thresholds, instead of the ones modelled by the input data (epidemic + 3 intensity thresholds)}

\item{i.color.pattern}{colors to use in the graph.}

\item{...}{other parameters passed to memmodel.}
}
\value{
\code{full.series.graph} writes a tiff graph of the full series of the dataset.

Color codes:
1: Axis.
2: Tickmarks.
3: Axis labels.
4: Series line.
5: Series dots (default).
6: Title and subtitle.
7: Series dots (pre-epidemic).
8: Series dots (epidemic).
9: Series dots (post-epidemic).
10: Epidemic threshold.
11: Medium threshold.
12: High threshold.
13: Very high threshold.
}
\description{
Function \code{full.series.graph} creates a graph with the whole data.
}
\details{
Input data must be a data.frame with each column a surveillance season and each
row a week.
}
\examples{
# Castilla y Leon Influenza Rates data
data(flucyl)
# Data of the last season
full.series.graph(flucyl)

}
\references{
Vega Alonso, Tomas, Jose E Lozano Alonso, Raul Ortiz de Lejarazu, and Marisol Gutierrez Perez. 2004.
Modelling Influenza Epidemic: Can We Detect the Beginning and Predict the Intensity and Duration?
International Congress Series, Options for the Control of Influenza V. Proceedings of the International
Conference on Options for the Control of Influenza V, 1263 (June): 281-83. doi:10.1016/j.ics.2004.02.121.\cr
Vega, Tomas, Jose Eugenio Lozano, Tamara Meerhoff, Rene Snacken, Joshua Mott, Raul Ortiz de Lejarazu, and
Baltazar Nunes. 2013. Influenza Surveillance in Europe: Establishing Epidemic Thresholds by the Moving
Epidemic Method. Influenza and Other Respiratory Viruses 7 (4): 546-58. doi:10.1111/j.1750-2659.2012.00422.x.\cr
Vega, Tomas, Jose E. Lozano, Tamara Meerhoff, Rene Snacken, Julien Beaute, Pernille Jorgensen, Raul Ortiz
de Lejarazu, et al. 2015. Influenza Surveillance in Europe: Comparing Intensity Levels Calculated Using
the Moving Epidemic Method. Influenza and Other Respiratory Viruses 9 (5): 234-46. doi:10.1111/irv.12330.
}
\author{
Jose E. Lozano \email{lozalojo@gmail.com}
}
\keyword{influenza}
