% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merList.R
\name{lmerModList}
\alias{lmerModList}
\alias{blmerModList}
\alias{glmerModList}
\alias{bglmerModList}
\title{Apply a multilevel model to a list of data frames}
\usage{
lmerModList(formula, data, parallel = FALSE, ...)

blmerModList(formula, data, parallel = FALSE, ...)

glmerModList(formula, data, parallel = FALSE, ...)

bglmerModList(formula, data, parallel = FALSE, ...)
}
\arguments{
\item{formula}{a formula to pass through compatible with merMod}

\item{data}{a list object with each element being a data.frame}

\item{parallel}{logical, should the models be run in parallel? Default FALSE. If so,
the `future_lapply` function from the `future.apply` package is used. See
details.}

\item{...}{additional arguments to pass to the estimating function}
}
\value{
a list of fitted merMod objects of class merModList

a merModList

a merModList

a merModList
}
\description{
Apply a multilevel model to a list of data frames

Apply a Bayesian multilevel model to a list of data frames

Apply a generalized linear multilevel model to a list of data frames

Apply a Bayesian generalized linear multilevel model to a list of data frames
}
\details{
Parallel computing is provided by the `futures` package, and its
extension the `future.apply` package to provide the `future_lapply` function
for easy parallel computations on lists. To use this package, simply register
a parallel backend using the `plan()` function from `futures` - an example
is to use `plan(multisession)`
}
\examples{
\donttest{
sim_list <- replicate(n = 10,
        expr = sleepstudy[sample(row.names(sleepstudy), 180),],
        simplify=FALSE)
fml <- "Reaction ~ Days + (Days | Subject)"
mod <- lmerModList(fml, data = sim_list)
summary(mod)
}
}
