% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getDates.R
\name{getDates}
\alias{getDates}
\title{Filter environmental monitoring stations by active date(s)}
\usage{
getDates(startDate, endDate, includeUnk = FALSE, ...)
}
\arguments{
\item{startDate}{(character) "YYYY-MM-DD" used to filter start dates of environmental stations within the metScanR database. Optional if \code{endDate} is initialized. Required if \code{endDate} is missing.}

\item{endDate}{(character) "YYYY-MM-DD" used to filter end dates of environmental stations within the metScanR  database. Optional if \code{startDate} is initialized. Required if \code{startDate} is missing.}

\item{includeUnk}{(logical) Defaults to FALSE and excludes sites with unknown start dates.  Setting to TRUE will include sites with unknown start dates.  Sites with unknown start dates account for ~71 percent of the metScanR database.  This is a result of undocumented, government (or network/governing body) metadata. Nearly all stations within the database have a known end date, however.  Initializing endDate (while leaving startDate uninitialized) and setting includeUnk=TRUE will more than likely return results than if startDate is also initialized.}

\item{...}{auto-populates when called from \code{siteFinder()} wrapper}
}
\value{
A list comprising metadata of environmental monitoring sites that were/are active between the \code{startDate} and/or \code{endDate}\cr
}
\description{
Return metadata of environmental monitoring stations that were/are active during specified dates.
}
\examples{
\dontrun{
#return metadata of sites that were active from at least 1940-01-01 through 1970-04-18
  getDates(startDate="1940-01-01",endDate = "1970-04-18")
#return metadata of sites that were active up through at least 1950-07-08
  getDates(endDate = "1950-07-08")
#return metadata of sites that were active up through at least 1950-07-08
#and have an unknown start date:
  getDates(endDate = "1950-07-08", includeUnk=TRUE)}
}
\references{
see reference links above
}
\seealso{
\link[metScanR]{siteFinder}
\link[metScanR]{mapResults}
\link[metScanR]{metScanR_DB}
}
\author{
Josh Roberti \email{jaroberti87@gmail.com} \cr
Lee Stanish \cr
}
