% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/amlodipine.R
\docType{data}
\name{amlodipine}
\alias{amlodipine}
\title{Amlodipine for Work Capacity}
\format{A data frame with the following columns:
\tabular{rl}{
\bold{\emph{study}}\tab study label \cr
\bold{\emph{n.amlo}}\tab number of observations in amlodipine group
  \cr
\bold{\emph{mean.amlo}}\tab estimated mean in amlodipine group \cr
\bold{\emph{var.amlo}}\tab variance in amlodipine group \cr
\bold{\emph{n.plac}}\tab number of observations in placebo group
  \cr
\bold{\emph{mean.plac}}\tab estimated mean in placebo group \cr
\bold{\emph{var.plac}}\tab variance in placebo group
}}
\source{
Hartung J & Knapp G (2001):
On tests of the overall treatment effect in meta-analysis with
normally distributed responses.
\emph{Statistics in Medicine},
\bold{20}, 1771--82
}
\description{
Meta-analysis on the effect of amlodipine on work capacity.

This meta-analysis is used as a data example in Hartung and Knapp (2001).
}
\examples{
data(amlodipine)

m <- metacont(n.amlo, mean.amlo, sqrt(var.amlo),
              n.plac, mean.plac, sqrt(var.plac),
              data = amlodipine, studlab = study)
s1 <- summary(m)
s2 <- summary(update(m, hakn = TRUE))

vars <- c("TE", "lower", "upper")

# Same results for mean difference as in Table III in Hartung and
# Knapp (2001)
#
res.md <- rbind(data.frame(s1$fixed)[vars],
                data.frame(s1$random)[vars],
                data.frame(s2$random)[vars])
#
res.md <- round(res.md, 5)
#
row.names(res.md) <- c("FE", "RE", "RE (HaKn)")
names(res.md) <- c("Absolute difference", "CI lower", "CI upper")
#
res.md
}
\seealso{
\code{\link{metacont}}
}
\keyword{datasets}
