% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/longarm.R
\name{longarm}
\alias{longarm}
\title{Transform data from pairwise comparisons to long arm-based format}
\usage{
longarm(
  treat1,
  treat2,
  event1,
  n1,
  event2,
  n2,
  mean1,
  sd1,
  mean2,
  sd2,
  time1,
  time2,
  data = NULL,
  studlab,
  id1 = NULL,
  id2 = NULL,
  append = TRUE,
  keep.duplicated = FALSE,
  keep.internal = FALSE
)
}
\arguments{
\item{treat1}{Either label for first treatment or a meta-analysis
or pairwise object (see Details).}

\item{treat2}{Label for second treatment.}

\item{event1}{Number of events (first treatment).}

\item{n1}{Number of observations (first treatment).}

\item{event2}{Number of events (second treatment).}

\item{n2}{Number of observations (second treatment)}

\item{mean1}{Estimated mean (first treatment).}

\item{sd1}{Standard deviation (first treatment).}

\item{mean2}{Estimated mean (second treatment).}

\item{sd2}{Standard deviation (second treatment).}

\item{time1}{Person time at risk (first treatment)}

\item{time2}{Person time at risk (second treatment)}

\item{data}{An optional data frame containing the study
information.}

\item{studlab}{A vector with study labels (optional).}

\item{id1}{Last character(s) of variable names for additional
variables with group specific information for first treatment.}

\item{id2}{Last character(s) of variable names for additional
variables with group specific information for second treatment.}

\item{append}{A logical indicating if data frame provided in
argument 'data' should be returned.}

\item{keep.duplicated}{A logical indicating if duplicated rows
should be returned (see Details).}

\item{keep.internal}{A logical indicating if variables generated
internally should be returned (typically only relevant for data
checking).}
}
\value{
A data frame in long arm-based format.
}
\description{
This function transforms data from pairwise comparisons to a long
arm-based format, i.e., two rows for a pairwise comparison.
}
\details{
This function transforms data given as one pairwise comparison per
row to a long arm-based format with one row per treatment arm. The
long arm-based format is, for example, the required input format
for WinBUGS.

The function can be used to transform data with a binary,
continuous or count outcome. The corresponding meta-analysis
functions are \code{\link{metabin}}, \code{\link{metacont}} and
\code{\link{metainc}}. Accordingly, a meta-analysis object created
with one of these functions can be provided as argument
\code{treat1}. It is also possible to use the longarm function with
an R objected created with \code{\link{pairwise}}.

Otherwise, arguments \code{treat1} and \code{treat2} are mandatory
to identify the individual treatments and, depending on the
outcome, the following additional arguments are mandatory:

\itemize{
\item event1, n1, event2, n2 (binary outcome);
\item n1, mean1, sd1, n2, mean2, sd2 (continuous outcome);
\item time1, n1, time2, n2 (count outcome).
}

Argument \code{studlab} must be provided if several pairwise
comparisons come from a single study with more than two treatments.

The following variables will be returned:

\tabular{rl}{
\bold{\emph{studlab}}\tab study label \cr
\bold{\emph{treat}}\tab treatment label \cr
\bold{\emph{n}}\tab group sample size (count outcome only if provided) \cr
\bold{\emph{events}}\tab number of events (binary or count outcome) \cr
\bold{\emph{nonevents}}\tab number of non-events (binary outcome) \cr
\bold{\emph{mean}}\tab estimated mean (continuous outcome) \cr
\bold{\emph{sd}}\tab standard deviation (continuous outcome) \cr
\bold{\emph{time}}\tab person time at risk (count outcome) \cr
}

In addition, the data set provided in argument \code{data} will be
returned if argument \code{append = TRUE} (default).

Argument \code{keep.duplicated} can be used to keep duplicated rows
from the data set. Duplicated rows can occur, for example, in a
three-arm study comparing treatments A and B with placebo. In this
situation, the placebo arm will be returned twice in the data set
in long arm-based format if \code{keep.duplicated = TRUE}. By
default, duplicated rows with not be kept in the data set.
}
\note{
R function \code{\link[metafor]{to.long}} from R package
\bold{metafor} is called internally.
}
\examples{
# Artificial example with three studies
m <- metabin(1:3, 100:102, 4:6, 200:202, studlab = LETTERS[1:3])
# Transform data to long arm-based format
longarm(m)
# Keep internal variables
longarm(m, keep.internal = TRUE)

}
\seealso{
\code{\link{metabin}}, \code{\link{metacont}},
  \code{\link{metainc}}, \code{\link{pairwise}}
}
\author{
Guido Schwarzer \email{guido.schwarzer@uniklinik-freiburg.de}
}
\keyword{datagen}
