% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metabolic_scaling.R
\name{calculate_normalization_constant}
\alias{calculate_normalization_constant}
\title{Normalization constant calculation}
\usage{
calculate_normalization_constant(
  parameter_value,
  scaling_exponent,
  mass,
  reference_temperature,
  E = NULL,
  k = 8.617333e-05,
  warn_if_possibly_false_input = getOption("metaRange.verbose", default = FALSE) > 0
)
}
\arguments{
\item{parameter_value}{\verb{<numeric>} parameter value at the reference temperature.}

\item{scaling_exponent}{\verb{<numeric>} allometric scaling exponent of the mass.}

\item{mass}{\verb{<numeric>}  mean (individual) mass.}

\item{reference_temperature}{\verb{<numeric>} reference temperature in kelvin (K).}

\item{E}{\verb{<numeric>} Activation energy in electronvolts (eV).}

\item{k}{\verb{<numeric>} Boltzmann's constant (eV / K).}

\item{warn_if_possibly_false_input}{\verb{<boolean>} Print a warning if the input
is different from the known literature value combinations.}
}
\value{
The calculated normalization constant.
}
\description{
Calculates the normalization constant for the metabolic scaling
based on a known or estimated parameter value under at a reference temperature.
}
\details{
Note the different scaling values for different parameter.
The following is a summary from table 4 in Brown, Sibly and Kodric-Brown (2012)
(see references).\tabular{lcr}{
   Parameter \tab Scaling exponent \tab Activation energy \cr
   resource usage \tab 3/4 \tab -0.65 \cr
   reproduction, mortality \tab -1/4 \tab -0.65 \cr
   carrying capacity \tab -3/4 \tab 0.65 \cr
}
}
\examples{
calculate_normalization_constant(
    parameter_value = 1,
    scaling_exponent = -1 / 4,
    mass = 1,
    reference_temperature = 273.15,
    E = -0.65
)
}
\references{
Brown, J.H., Gillooly, J.F., Allen, A.P., Savage, V.M. and West, G.B. (2004)
Toward a Metabolic Theory of Ecology. \emph{Ecology}, \strong{85} 1771--1789.
\doi{10.1890/03-9000}

Brown, J.H., Sibly, R.M. and Kodric-Brown, A. (2012)
Introduction: Metabolism as the Basis for a Theoretical Unification of Ecology.
In \emph{Metabolic Ecology} (eds R.M. Sibly, J.H. Brown and A. Kodric-Brown)
\doi{10.1002/9781119968535.ch}
}
\seealso{
\code{metabolic_scaling()}
}
