% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Class_Simulation.R
\name{metaRangeSimulation}
\alias{metaRangeSimulation}
\title{metaRangeSimulation object}
\value{
A \verb{<metaRangeSimulation>} object
}
\description{
Creates an simulation object in form of an
\link[R6:R6Class]{R6} class that stores and handles all the individual parts
that are necessary to run a simulation.
}
\examples{

## ------------------------------------------------
## Method `metaRangeSimulation$new`
## ------------------------------------------------

sim_env <- terra::sds(terra::rast(nrow = 2, ncol = 2))
sim <- metaRangeSimulation$new(source_environment = sim_env)
sim

## ------------------------------------------------
## Method `metaRangeSimulation$add_globals`
## ------------------------------------------------

sim_env <- terra::sds(terra::rast(nrow = 2, ncol = 2))
sim <- metaRangeSimulation$new(source_environment = sim_env)
sim$add_globals(a = 1, b = 2)
sim$globals$a
#> [1] 1

## ------------------------------------------------
## Method `metaRangeSimulation$set_time_layer_mapping`
## ------------------------------------------------

sim_env <- terra::sds(terra::rast(nrow = 2, ncol = 2, nlyr = 4))
sim <- metaRangeSimulation$new(source_environment = sim_env)
sim$set_time_layer_mapping(1:2)
stopifnot(identical(sim$time_step_layer, 1:2))

## ------------------------------------------------
## Method `metaRangeSimulation$get_current_time_step`
## ------------------------------------------------

sim_env <- terra::sds(terra::rast(nrow = 2, ncol = 2))
sim <- metaRangeSimulation$new(source_environment = sim_env)
sim$get_current_time_step()
#> [1] 1

## ------------------------------------------------
## Method `metaRangeSimulation$add_species`
## ------------------------------------------------

sim_env <- terra::sds(terra::rast(nrow = 2, ncol = 2))
sim <- metaRangeSimulation$new(source_environment = sim_env)
sim$add_species("species_1")
sim$species_1

## ------------------------------------------------
## Method `metaRangeSimulation$species_names`
## ------------------------------------------------

sim_env <- terra::sds(terra::rast(nrow = 2, ncol = 2))
sim <- metaRangeSimulation$new(source_environment = sim_env)
sim$add_species("species_1")
sim$add_species("species_2")
sim$species_names()
#> [1] "species_1" "species_2"

## ------------------------------------------------
## Method `metaRangeSimulation$add_process`
## ------------------------------------------------

sim_env <- terra::sds(terra::rast(nrow = 2, ncol = 2))
sim <- metaRangeSimulation$new(source_environment = sim_env)
sim$add_species("species_1")
sim$add_process("species_1", "species_process_1", function() {message("process_1")}, 1)
sim$species_1$processes$species_process_1
sim$add_process(species = NULL, "global_process_2", function() {message("process_2")}, 2)
sim$processes$global_process_2

## ------------------------------------------------
## Method `metaRangeSimulation$add_traits`
## ------------------------------------------------

sim_env <- terra::sds(terra::rast(nrow = 2, ncol = 2))
sim <- metaRangeSimulation$new(source_environment = sim_env)
sim$add_species("species_1")
sim$add_traits("species_1", population_level = TRUE, a = 1)
sim$add_traits("species_1", population_level = FALSE, b = 2, c = "c")
sim$species_1$traits$a
#>      [,1] [,2]
#> [1,]    1    1
#> [2,]    1    1
sim$species_1$traits$b
#> [1] 2
sim$species_1$traits$c
#> [1] "c"

## ------------------------------------------------
## Method `metaRangeSimulation$exit`
## ------------------------------------------------

sim_env <- terra::sds(terra::rast(vals = 1, nrow = 2, ncol = 2, nlyr = 4))
names(sim_env) <- "env_var_name"
sim <- metaRangeSimulation$new(source_environment = sim_env)
sim$add_species("species_1")
sim$add_process("species_1", "species_process_1", function() {self$sim$exit()}, 1)
sim$begin()

## ------------------------------------------------
## Method `metaRangeSimulation$begin`
## ------------------------------------------------

sim_env <- terra::sds(terra::rast(vals = 1, nrow = 2, ncol = 2, nlyr = 4))
names(sim_env) <- "env_var_name"
sim <- metaRangeSimulation$new(source_environment = sim_env)
sim$add_process(
     species = NULL,
     "timestep_counter",
     function() {
         message("timestep: ", self$get_current_time_step())
     },
     1
)
sim$begin()

## ------------------------------------------------
## Method `metaRangeSimulation$print`
## ------------------------------------------------

sim_env <- terra::sds(terra::rast(nrow = 2, ncol = 2))
sim <- metaRangeSimulation$new(source_environment = sim_env)
sim$print()

## ------------------------------------------------
## Method `metaRangeSimulation$summary`
## ------------------------------------------------

sim_env <- terra::sds(terra::rast(nrow = 2, ncol = 2))
sim <- metaRangeSimulation$new(source_environment = sim_env)
sim$summary()
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{ID}}{\verb{<string>} simulation identification.}

\item{\code{globals}}{\verb{<environment>} a place to store global variables.}

\item{\code{environment}}{\verb{<metaRangeEnvironment>} A \link{metaRangeEnvironment}
that holds all the environmental values influencing the simulation.}

\item{\code{number_time_steps}}{\verb{<integer>} number of time steps in the simulation.}

\item{\code{time_step_layer}}{\verb{<integer>} vector of layer IDs
that describe which environmental layer to use at each time step.}

\item{\code{current_time_step}}{\verb{<integer>} current time step.}

\item{\code{queue}}{\verb{<metaRangePriorityQueue>} manages the order in which the processes should be executed.}

\item{\code{processes}}{\verb{<list>} of global (simulation level) \verb{<metaRangeProcess>} (es).}

\item{\code{seed}}{\verb{<integer>} seed for the random number generator.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-metaRangeSimulation-new}{\code{metaRangeSimulation$new()}}
\item \href{#method-metaRangeSimulation-add_globals}{\code{metaRangeSimulation$add_globals()}}
\item \href{#method-metaRangeSimulation-set_time_layer_mapping}{\code{metaRangeSimulation$set_time_layer_mapping()}}
\item \href{#method-metaRangeSimulation-get_current_time_step}{\code{metaRangeSimulation$get_current_time_step()}}
\item \href{#method-metaRangeSimulation-add_species}{\code{metaRangeSimulation$add_species()}}
\item \href{#method-metaRangeSimulation-species_names}{\code{metaRangeSimulation$species_names()}}
\item \href{#method-metaRangeSimulation-add_process}{\code{metaRangeSimulation$add_process()}}
\item \href{#method-metaRangeSimulation-add_traits}{\code{metaRangeSimulation$add_traits()}}
\item \href{#method-metaRangeSimulation-exit}{\code{metaRangeSimulation$exit()}}
\item \href{#method-metaRangeSimulation-begin}{\code{metaRangeSimulation$begin()}}
\item \href{#method-metaRangeSimulation-print}{\code{metaRangeSimulation$print()}}
\item \href{#method-metaRangeSimulation-summary}{\code{metaRangeSimulation$summary()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-metaRangeSimulation-new"></a>}}
\if{latex}{\out{\hypertarget{method-metaRangeSimulation-new}{}}}
\subsection{Method \code{new()}}{
Creates a new \link{metaRangeSimulation} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{metaRangeSimulation$new(source_environment, ID = NULL, seed = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{source_environment}}{\verb{<SpatRasterDataset>} created by \code{\link[terra:sds]{terra::sds()}} that represents the environment.
The individual data sets represent different environmental variables
(e.g. temperature or habitat availability) and the different layer of the data sets
represent the different timesteps of the simulation.
The function \link{metaRangeSimulation}\verb{$set_time_layer_mapping()} can be used
to extend/ shorten the simulation timesteps and set the mapping between each time step and a corresponding
environmental layer. This can be used e.g. to repeat the first (few) layer as a burn-in period.
The number of layers must be the same for all data sets.}

\item{\code{ID}}{\verb{<string>} optional simulation identification string.
Will be set automatically if none is specified.}

\item{\code{seed}}{\verb{<integer>} optional seed for the random number generator.
Will be set automatically if none is specified.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \verb{<metaRangeSimulation>} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{sim_env <- terra::sds(terra::rast(nrow = 2, ncol = 2))
sim <- metaRangeSimulation$new(source_environment = sim_env)
sim
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-metaRangeSimulation-add_globals"></a>}}
\if{latex}{\out{\hypertarget{method-metaRangeSimulation-add_globals}{}}}
\subsection{Method \code{add_globals()}}{
Add global variables to the simulation
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{metaRangeSimulation$add_globals(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{\verb{<any>} the variables to add.
Variables to add to the simulation. They will be saved and accessible
through the 'globals' field.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\verb{<invisible self>}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{sim_env <- terra::sds(terra::rast(nrow = 2, ncol = 2))
sim <- metaRangeSimulation$new(source_environment = sim_env)
sim$add_globals(a = 1, b = 2)
sim$globals$a
#> [1] 1
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-metaRangeSimulation-set_time_layer_mapping"></a>}}
\if{latex}{\out{\hypertarget{method-metaRangeSimulation-set_time_layer_mapping}{}}}
\subsection{Method \code{set_time_layer_mapping()}}{
Set the time layer of the simulation.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{metaRangeSimulation$set_time_layer_mapping(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{\verb{<integer>} vector of layer indices
that describe which environmental layer to use at each time step.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\verb{<invisible self>}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{sim_env <- terra::sds(terra::rast(nrow = 2, ncol = 2, nlyr = 4))
sim <- metaRangeSimulation$new(source_environment = sim_env)
sim$set_time_layer_mapping(1:2)
stopifnot(identical(sim$time_step_layer, 1:2))
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-metaRangeSimulation-get_current_time_step"></a>}}
\if{latex}{\out{\hypertarget{method-metaRangeSimulation-get_current_time_step}{}}}
\subsection{Method \code{get_current_time_step()}}{
Get current time step
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{metaRangeSimulation$get_current_time_step()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\verb{<integer>} the current time step
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{sim_env <- terra::sds(terra::rast(nrow = 2, ncol = 2))
sim <- metaRangeSimulation$new(source_environment = sim_env)
sim$get_current_time_step()
#> [1] 1
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-metaRangeSimulation-add_species"></a>}}
\if{latex}{\out{\hypertarget{method-metaRangeSimulation-add_species}{}}}
\subsection{Method \code{add_species()}}{
Adds a new species to the simulation
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{metaRangeSimulation$add_species(name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{\verb{<string>} name or ID of the species.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\verb{<invisible boolean>} \code{TRUE} on success \code{FALSE} on failure.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{sim_env <- terra::sds(terra::rast(nrow = 2, ncol = 2))
sim <- metaRangeSimulation$new(source_environment = sim_env)
sim$add_species("species_1")
sim$species_1
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-metaRangeSimulation-species_names"></a>}}
\if{latex}{\out{\hypertarget{method-metaRangeSimulation-species_names}{}}}
\subsection{Method \code{species_names()}}{
Returns the names of all species in the simulation.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{metaRangeSimulation$species_names()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\verb{<character>} vector of species names
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{sim_env <- terra::sds(terra::rast(nrow = 2, ncol = 2))
sim <- metaRangeSimulation$new(source_environment = sim_env)
sim$add_species("species_1")
sim$add_species("species_2")
sim$species_names()
#> [1] "species_1" "species_2"
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-metaRangeSimulation-add_process"></a>}}
\if{latex}{\out{\hypertarget{method-metaRangeSimulation-add_process}{}}}
\subsection{Method \code{add_process()}}{
Adds a process to the simulation.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{metaRangeSimulation$add_process(
  species = NULL,
  process_name,
  process_fun,
  execution_priority,
  queue = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{species}}{\verb{<string>} Name of the species that the process should be added to.
If \code{NULL} the process will be added to the simulation object itself.}

\item{\code{process_name}}{\verb{<string>} Name of the process to add.}

\item{\code{process_fun}}{\verb{<named function>} The function to call when the process gets executed.}

\item{\code{execution_priority}}{\verb{<positive integer>} When this process should run within each time step.
1 == highest priority i.e. this function will be the executed first.}

\item{\code{queue}}{\verb{<boolean>} If \code{TRUE} the process will be added to the process execution queue directly.
If \code{FALSE} the process will be added to the simulation but not to the queue,
which means that in order to execute the process, it has to be added manually
via the \link{metaRangePriorityQueue}\verb{$enqueue()} method.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\verb{<invisible self>}.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{sim_env <- terra::sds(terra::rast(nrow = 2, ncol = 2))
sim <- metaRangeSimulation$new(source_environment = sim_env)
sim$add_species("species_1")
sim$add_process("species_1", "species_process_1", function() {message("process_1")}, 1)
sim$species_1$processes$species_process_1
sim$add_process(species = NULL, "global_process_2", function() {message("process_2")}, 2)
sim$processes$global_process_2
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-metaRangeSimulation-add_traits"></a>}}
\if{latex}{\out{\hypertarget{method-metaRangeSimulation-add_traits}{}}}
\subsection{Method \code{add_traits()}}{
Adds traits to a species.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{metaRangeSimulation$add_traits(species, population_level = TRUE, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{species}}{\verb{<string>} Name of the species that the traits should be added to.}

\item{\code{population_level}}{\verb{<boolean>} If \code{TRUE} the traits will be added at the population level
(i.e. as a matrix with same dimensions (nrow/ncol) as the environment with one value for each population).
This means that the traits either need to be single values that will be extended
to such a matrix via \code{\link[base:matrix]{base::matrix()}} or they already need to be a matrix with these dimension.
If \code{FALSE} the traits will be added without any conversion and may have any type and dimension.}

\item{\code{...}}{\verb{<atomic>} (see \code{\link[base:is.recursive]{base::is.atomic()}}) The named traits to be added.
Named means: \code{Name = value} e.g. \code{a = 1}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\verb{<invisible self>}.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{sim_env <- terra::sds(terra::rast(nrow = 2, ncol = 2))
sim <- metaRangeSimulation$new(source_environment = sim_env)
sim$add_species("species_1")
sim$add_traits("species_1", population_level = TRUE, a = 1)
sim$add_traits("species_1", population_level = FALSE, b = 2, c = "c")
sim$species_1$traits$a
#>      [,1] [,2]
#> [1,]    1    1
#> [2,]    1    1
sim$species_1$traits$b
#> [1] 2
sim$species_1$traits$c
#> [1] "c"
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-metaRangeSimulation-exit"></a>}}
\if{latex}{\out{\hypertarget{method-metaRangeSimulation-exit}{}}}
\subsection{Method \code{exit()}}{
When called, will end the simulation (prematurely) once the current process is finished.
Useful to e.g. end the simulation safely (i.e. without an error) when no species is alive anymore
and there would be no benefit to continue the execution until the last time step.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{metaRangeSimulation$exit()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\verb{invisible NULL}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{sim_env <- terra::sds(terra::rast(vals = 1, nrow = 2, ncol = 2, nlyr = 4))
names(sim_env) <- "env_var_name"
sim <- metaRangeSimulation$new(source_environment = sim_env)
sim$add_species("species_1")
sim$add_process("species_1", "species_process_1", function() {self$sim$exit()}, 1)
sim$begin()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-metaRangeSimulation-begin"></a>}}
\if{latex}{\out{\hypertarget{method-metaRangeSimulation-begin}{}}}
\subsection{Method \code{begin()}}{
Begins the simulation
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{metaRangeSimulation$begin()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\verb{<invisible self>} The finished simulation
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{sim_env <- terra::sds(terra::rast(vals = 1, nrow = 2, ncol = 2, nlyr = 4))
names(sim_env) <- "env_var_name"
sim <- metaRangeSimulation$new(source_environment = sim_env)
sim$add_process(
     species = NULL,
     "timestep_counter",
     function() {
         message("timestep: ", self$get_current_time_step())
     },
     1
)
sim$begin()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-metaRangeSimulation-print"></a>}}
\if{latex}{\out{\hypertarget{method-metaRangeSimulation-print}{}}}
\subsection{Method \code{print()}}{
Prints information about the simulation to the console
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{metaRangeSimulation$print()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\verb{<invisible self>}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{sim_env <- terra::sds(terra::rast(nrow = 2, ncol = 2))
sim <- metaRangeSimulation$new(source_environment = sim_env)
sim$print()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-metaRangeSimulation-summary"></a>}}
\if{latex}{\out{\hypertarget{method-metaRangeSimulation-summary}{}}}
\subsection{Method \code{summary()}}{
Summarizes information about the simulation and outputs
it to the console
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{metaRangeSimulation$summary()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\verb{<invisible self>}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{sim_env <- terra::sds(terra::rast(nrow = 2, ncol = 2))
sim <- metaRangeSimulation$new(source_environment = sim_env)
sim$summary()
}
\if{html}{\out{</div>}}

}

}
}
