% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{load_excel}
\alias{load_excel}
\title{Load metabolite data from an excel file}
\usage{
load_excel(
  path,
  data_sheet = NULL,
  feature_sheet = NULL,
  sample_sheet = NULL,
  featureID = "CHEM_ID",
  sampleID = "PARENT_SAMPLE_NAME"
)
}
\arguments{
\item{path}{Path to the xls/xlsx file.}

\item{data_sheet}{A integer of xlsx sheet number for metabolite measurements 
(peak area data or normalized data, sample [row] * feature [column])}

\item{feature_sheet}{A integer of xlsx sheet number for metabolite annotation (chemical annotation)}

\item{sample_sheet}{A integer of xlsx sheet number for sample annotation (sample meta data)}

\item{featureID}{a character of the metabolite ID column (in feature file and the column names of data file), 
default: CHEM_ID (provided from Metabolon file)}

\item{sampleID}{a character of the sample ID column (in sample file and the first column of data file), 
default: PARENT_SAMPLE_NAME (provided from Metabolon file)}
}
\value{
A Metabolite object with slots: assayData, featureData, and sampleData.
}
\description{
Load metabolite data from an excel file
}
