% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxmap--filter.R
\name{filter_obs}
\alias{filter_obs}
\title{Filter observations with a list of conditions}
\usage{
filter_obs(.data, ..., unobserved = TRUE)
}
\arguments{
\item{.data}{\code{\link{taxmap}}}

\item{...}{One or more filtering conditions. This can be one of two things: \describe{ 
\item{\code{integer}}{One or more indexes of \code{obs_data}} \item{\code{logical}}{A 
\code{TRUE}/\code{FALSE} vector of length equal to the number of rows in \code{obs_data}} } 
Any column name that appears in \code{obs_data(.data)} can be used as if it was a vector on 
its own.}

\item{unobserved}{(\code{logical} of length 1) If \code{TRUE}, preserve taxa even if all of their 
observations are filtered out. If \code{FALSE}, remove taxa for which all observations were filtered out. 
Note that only taxa that are unobserved due to this filtering will be removed; there might be 
other taxa without observations to begin with that will not be removed.}
}
\value{
An object of type \code{\link{taxmap}}
}
\description{
Filter observations in a \code{\link{taxmap}} object with a list of conditions. Any column name that
appears in \code{obs_data(.data)} can be used as if it was a vector on its own. See 
\code{\link[dplyr]{filter}} for inspiration and more information.
}
\examples{
# Filter by sequence name, but preserve all taxa
filter_obs(unite_ex_data_3, grepl("Lachnum", seq_name))
# Filter by sequence name and only keep taxa with sequences that pass the filter
filter_obs(unite_ex_data_3, grepl("Lachnum", seq_name), unobserved = FALSE)

}
\seealso{
Other dplyr-like functions: \code{\link{arrange_obs}},
  \code{\link{arrange_taxa}}, \code{\link{filter_taxa}},
  \code{\link{mutate_obs}}, \code{\link{mutate_taxa}},
  \code{\link{sample_frac_obs}},
  \code{\link{sample_frac_taxa}},
  \code{\link{sample_n_obs}}, \code{\link{sample_n_taxa}},
  \code{\link{select_obs}}, \code{\link{select_taxa}},
  \code{\link{transmute_obs}}, \code{\link{transmute_taxa}}
}

