% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset_documentation.R
\docType{data}
\name{genbank_ex_data}
\alias{genbank_ex_data}
\title{Fungal ITS Genbank refseq}
\format{An object of type \code{\link{taxmap}}}
\source{
\url{http://www.ncbi.nlm.nih.gov/nuccore}
}
\usage{
genbank_ex_data
}
\description{
A dataset containing information for 299 sequences obtained form NCBI using the following query:
}
\details{
\code{
(18s[All Fields] AND 28s[All Fields]) AND "basidiomycetes"[porgn] AND (refseq[filter] AND ("700"[SLEN] : "800"[SLEN]))
}
}
\examples{
\dontrun{

file_path <- system.file("extdata", "ncbi_basidiomycetes.fasta", package = "metacoder")
sequences <- ape::read.FASTA(file_path)
genbank_ex_data <- extract_taxonomy(sequences,
                                    regex = "^.*\\\\|(.*)\\\\|.*\\\\|(.*)\\\\|(.*)$",
                                    key = c(gi_no = "obs_info", "obs_id", desc = "obs_info"),
                                    database = "ncbi")
}
}
\keyword{datasets}

