% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxmap--class.R
\name{taxmap}
\alias{taxmap}
\title{Create an instance of \code{taxmap}}
\usage{
taxmap(taxon_ids, supertaxon_ids, taxa = taxon_ids,
  obs_taxon_ids = numeric(0), taxon_data = NULL, obs_data = NULL,
  taxon_funcs = list(n_obs = n_obs, n_obs_1 = n_obs_1, n_supertaxa =
  n_supertaxa, n_subtaxa = n_subtaxa, n_subtaxa_1 = n_subtaxa_1, hierarchies =
  hierarchies), obs_funcs = list())
}
\arguments{
\item{taxon_ids}{(\code{character}) 
These are unique identifiers for taxa.
They will be coerced into characters.}

\item{supertaxon_ids}{(\code{character} OR (\code{numeric}))
Supertaxa of \code{taxa}.
If a \code{character} vector, then these should be in the same format as \code{taxon_ids}.
If a \code{numeric} vector, then it is interpreted as the indexes of \code{taxon_ids}.
Taxa without parents should be \code{NA}.}

\item{taxa}{(\code{character})
Objects representing taxa.
Currently, these can be anything, but this might change in the future.}

\item{obs_taxon_ids}{(\code{character} OR (\code{numeric}))
Taxon assignments of observations.
Supertaxa of \code{taxa}.
If a \code{character} vector, then these should be in the same format as \code{taxon_ids}.
If a \code{numeric} vector, then it is interpreted as the indexes of \code{taxon_ids}.}

\item{taxon_data}{(\code{data.frame})
A table with rows pretaining to \code{taxa}}

\item{obs_data}{A (\code{data.frame})
A table with rows pretaining to \code{obs_taxa}}

\item{taxon_funcs}{(\code{list} of named \code{function}s)
These the values produced by these functions will be accessible as a column in \code{taxon_data}.
The first parameter of each function should be a single \code{taxmap} object.}

\item{obs_funcs}{(\code{list} of named \code{function}s)
These the values produced by these functions will be accessible as a column in \code{obs_data}.
The first parameter of each function should be a single \code{taxmap} object.}
}
\value{
An object of type \code{taxmap}
}
\description{
Create an instance of \code{taxmap} containing observations taxmap by a taxonomy.
}

